/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.jdbc;

import com.zaxxer.hikari.HikariDataSource;
import org.qubership.profiler.shaded.org.apache.commons.dbcp2.BasicDataSource;
import org.qubership.profiler.shaded.org.apache.tomcat.jdbc.pool.DataSource;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.qubership.profiler.shaded.org.springframework.boot.context.properties.ConfigurationProperties;
import org.qubership.profiler.shaded.org.springframework.boot.jdbc.DatabaseDriver;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Bean;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Configuration;

abstract class DataSourceConfiguration {
    DataSourceConfiguration() {
    }

    protected static <T> T createDataSource(DataSourceProperties properties, Class<? extends javax.sql.DataSource> type) {
        return (T)properties.initializeDataSourceBuilder().type(type).build();
    }

    @Configuration
    @ConditionalOnMissingBean(value={javax.sql.DataSource.class})
    @ConditionalOnProperty(name={"spring.datasource.type"})
    static class Generic {
        Generic() {
        }

        @Bean
        public javax.sql.DataSource dataSource(DataSourceProperties properties) {
            return properties.initializeDataSourceBuilder().build();
        }
    }

    @Configuration
    @ConditionalOnClass(value={BasicDataSource.class})
    @ConditionalOnMissingBean(value={javax.sql.DataSource.class})
    @ConditionalOnProperty(name={"spring.datasource.type"}, havingValue="org.qubership.profiler.shaded.org.apache.commons.dbcp2.BasicDataSource", matchIfMissing=true)
    static class Dbcp2 {
        Dbcp2() {
        }

        @Bean
        @ConfigurationProperties(prefix="spring.datasource.dbcp2")
        public BasicDataSource dataSource(DataSourceProperties properties) {
            return (BasicDataSource)DataSourceConfiguration.createDataSource(properties, BasicDataSource.class);
        }
    }

    @Configuration
    @ConditionalOnClass(value={org.qubership.profiler.shaded.org.apache.commons.dbcp.BasicDataSource.class})
    @ConditionalOnMissingBean(value={javax.sql.DataSource.class})
    @ConditionalOnProperty(name={"spring.datasource.type"}, havingValue="org.qubership.profiler.shaded.org.apache.commons.dbcp.BasicDataSource", matchIfMissing=true)
    @Deprecated
    static class Dbcp {
        Dbcp() {
        }

        @Bean
        @ConfigurationProperties(prefix="spring.datasource.dbcp")
        public org.qubership.profiler.shaded.org.apache.commons.dbcp.BasicDataSource dataSource(DataSourceProperties properties) {
            org.qubership.profiler.shaded.org.apache.commons.dbcp.BasicDataSource dataSource = (org.qubership.profiler.shaded.org.apache.commons.dbcp.BasicDataSource)DataSourceConfiguration.createDataSource(properties, org.qubership.profiler.shaded.org.apache.commons.dbcp.BasicDataSource.class);
            DatabaseDriver databaseDriver = DatabaseDriver.fromJdbcUrl(properties.determineUrl());
            String validationQuery = databaseDriver.getValidationQuery();
            if (validationQuery != null) {
                dataSource.setTestOnBorrow(true);
                dataSource.setValidationQuery(validationQuery);
            }
            return dataSource;
        }
    }

    @Configuration
    @ConditionalOnClass(value={HikariDataSource.class})
    @ConditionalOnMissingBean(value={javax.sql.DataSource.class})
    @ConditionalOnProperty(name={"spring.datasource.type"}, havingValue="com.zaxxer.hikari.HikariDataSource", matchIfMissing=true)
    static class Hikari {
        Hikari() {
        }

        @Bean
        @ConfigurationProperties(prefix="spring.datasource.hikari")
        public HikariDataSource dataSource(DataSourceProperties properties) {
            return (HikariDataSource)DataSourceConfiguration.createDataSource(properties, HikariDataSource.class);
        }
    }

    @Configuration
    @ConditionalOnClass(value={DataSource.class})
    @ConditionalOnMissingBean(value={javax.sql.DataSource.class})
    @ConditionalOnProperty(name={"spring.datasource.type"}, havingValue="org.qubership.profiler.shaded.org.apache.tomcat.jdbc.pool.DataSource", matchIfMissing=true)
    static class Tomcat {
        Tomcat() {
        }

        @Bean
        @ConfigurationProperties(prefix="spring.datasource.tomcat")
        public DataSource dataSource(DataSourceProperties properties) {
            DataSource dataSource = (DataSource)DataSourceConfiguration.createDataSource(properties, DataSource.class);
            DatabaseDriver databaseDriver = DatabaseDriver.fromJdbcUrl(properties.determineUrl());
            String validationQuery = databaseDriver.getValidationQuery();
            if (validationQuery != null) {
                dataSource.setTestOnBorrow(true);
                dataSource.setValidationQuery(validationQuery);
            }
            return dataSource;
        }
    }
}

