/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.jdbc.metadata;

import com.zaxxer.hikari.HikariDataSource;
import org.qubership.profiler.shaded.org.apache.commons.dbcp2.BasicDataSource;
import org.qubership.profiler.shaded.org.apache.tomcat.jdbc.pool.DataSource;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.jdbc.metadata.CommonsDbcp2DataSourcePoolMetadata;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.jdbc.metadata.CommonsDbcpDataSourcePoolMetadata;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.jdbc.metadata.DataSourcePoolMetadata;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.jdbc.metadata.DataSourcePoolMetadataProvider;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.jdbc.metadata.HikariDataSourcePoolMetadata;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.jdbc.metadata.TomcatDataSourcePoolMetadata;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Bean;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Configuration;

@Configuration
public class DataSourcePoolMetadataProvidersConfiguration {

    @Configuration
    @ConditionalOnClass(value={BasicDataSource.class})
    static class CommonsDbcp2PoolDataSourceMetadataProviderConfiguration {
        CommonsDbcp2PoolDataSourceMetadataProviderConfiguration() {
        }

        @Bean
        public DataSourcePoolMetadataProvider commonsDbcp2PoolDataSourceMetadataProvider() {
            return new DataSourcePoolMetadataProvider(){

                @Override
                public DataSourcePoolMetadata getDataSourcePoolMetadata(javax.sql.DataSource dataSource) {
                    if (dataSource instanceof BasicDataSource) {
                        return new CommonsDbcp2DataSourcePoolMetadata((BasicDataSource)dataSource);
                    }
                    return null;
                }
            };
        }
    }

    @Configuration
    @ConditionalOnClass(value={org.qubership.profiler.shaded.org.apache.commons.dbcp.BasicDataSource.class})
    @Deprecated
    static class CommonsDbcpPoolDataSourceMetadataProviderConfiguration {
        CommonsDbcpPoolDataSourceMetadataProviderConfiguration() {
        }

        @Bean
        public DataSourcePoolMetadataProvider commonsDbcpPoolDataSourceMetadataProvider() {
            return new DataSourcePoolMetadataProvider(){

                @Override
                public DataSourcePoolMetadata getDataSourcePoolMetadata(javax.sql.DataSource dataSource) {
                    if (dataSource instanceof org.qubership.profiler.shaded.org.apache.commons.dbcp.BasicDataSource) {
                        return new CommonsDbcpDataSourcePoolMetadata((org.qubership.profiler.shaded.org.apache.commons.dbcp.BasicDataSource)dataSource);
                    }
                    return null;
                }
            };
        }
    }

    @Configuration
    @ConditionalOnClass(value={HikariDataSource.class})
    static class HikariPoolDataSourceMetadataProviderConfiguration {
        HikariPoolDataSourceMetadataProviderConfiguration() {
        }

        @Bean
        public DataSourcePoolMetadataProvider hikariPoolDataSourceMetadataProvider() {
            return new DataSourcePoolMetadataProvider(){

                @Override
                public DataSourcePoolMetadata getDataSourcePoolMetadata(javax.sql.DataSource dataSource) {
                    if (dataSource instanceof HikariDataSource) {
                        return new HikariDataSourcePoolMetadata((HikariDataSource)dataSource);
                    }
                    return null;
                }
            };
        }
    }

    @Configuration
    @ConditionalOnClass(value={DataSource.class})
    static class TomcatDataSourcePoolMetadataProviderConfiguration {
        TomcatDataSourcePoolMetadataProviderConfiguration() {
        }

        @Bean
        public DataSourcePoolMetadataProvider tomcatPoolDataSourceMetadataProvider() {
            return new DataSourcePoolMetadataProvider(){

                @Override
                public DataSourcePoolMetadata getDataSourcePoolMetadata(javax.sql.DataSource dataSource) {
                    if (dataSource instanceof DataSource) {
                        return new TomcatDataSourcePoolMetadata((DataSource)dataSource);
                    }
                    return null;
                }
            };
        }
    }
}

