/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.jms;

import javax.jms.ConnectionFactory;
import org.qubership.profiler.shaded.org.springframework.beans.factory.ObjectProvider;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnJndi;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.jms.DefaultJmsListenerContainerFactoryConfigurer;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.jms.JmsProperties;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Bean;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Configuration;
import org.qubership.profiler.shaded.org.springframework.jms.annotation.EnableJms;
import org.qubership.profiler.shaded.org.springframework.jms.config.DefaultJmsListenerContainerFactory;
import org.qubership.profiler.shaded.org.springframework.jms.support.converter.MessageConverter;
import org.qubership.profiler.shaded.org.springframework.jms.support.destination.DestinationResolver;
import org.qubership.profiler.shaded.org.springframework.jms.support.destination.JndiDestinationResolver;
import org.qubership.profiler.shaded.org.springframework.transaction.jta.JtaTransactionManager;

@Configuration
@ConditionalOnClass(value={EnableJms.class})
class JmsAnnotationDrivenConfiguration {
    private final ObjectProvider<DestinationResolver> destinationResolver;
    private final ObjectProvider<JtaTransactionManager> transactionManager;
    private final ObjectProvider<MessageConverter> messageConverter;
    private final JmsProperties properties;

    JmsAnnotationDrivenConfiguration(ObjectProvider<DestinationResolver> destinationResolver, ObjectProvider<JtaTransactionManager> transactionManager, ObjectProvider<MessageConverter> messageConverter, JmsProperties properties) {
        this.destinationResolver = destinationResolver;
        this.transactionManager = transactionManager;
        this.messageConverter = messageConverter;
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    public DefaultJmsListenerContainerFactoryConfigurer jmsListenerContainerFactoryConfigurer() {
        DefaultJmsListenerContainerFactoryConfigurer configurer = new DefaultJmsListenerContainerFactoryConfigurer();
        configurer.setDestinationResolver(this.destinationResolver.getIfUnique());
        configurer.setTransactionManager(this.transactionManager.getIfUnique());
        configurer.setMessageConverter(this.messageConverter.getIfUnique());
        configurer.setJmsProperties(this.properties);
        return configurer;
    }

    @Bean
    @ConditionalOnMissingBean(name={"jmsListenerContainerFactory"})
    public DefaultJmsListenerContainerFactory jmsListenerContainerFactory(DefaultJmsListenerContainerFactoryConfigurer configurer, ConnectionFactory connectionFactory) {
        DefaultJmsListenerContainerFactory factory = new DefaultJmsListenerContainerFactory();
        configurer.configure(factory, connectionFactory);
        return factory;
    }

    @Configuration
    @ConditionalOnJndi
    protected static class JndiConfiguration {
        protected JndiConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={DestinationResolver.class})
        public JndiDestinationResolver destinationResolver() {
            JndiDestinationResolver resolver = new JndiDestinationResolver();
            resolver.setFallbackToDynamicDestination(true);
            return resolver;
        }
    }

    @Configuration
    @EnableJms
    @ConditionalOnMissingBean(name={"org.qubership.profiler.shaded.org.springframework.jms.config.internalJmsListenerAnnotationProcessor"})
    protected static class EnableJmsConfiguration {
        protected EnableJmsConfiguration() {
        }
    }
}

