/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.jmx;

import javax.management.MBeanServer;
import org.qubership.profiler.shaded.org.springframework.beans.BeansException;
import org.qubership.profiler.shaded.org.springframework.beans.factory.BeanFactory;
import org.qubership.profiler.shaded.org.springframework.beans.factory.BeanFactoryAware;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.jmx.ParentAwareNamingStrategy;
import org.qubership.profiler.shaded.org.springframework.boot.bind.RelaxedPropertyResolver;
import org.qubership.profiler.shaded.org.springframework.context.EnvironmentAware;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Bean;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Configuration;
import org.qubership.profiler.shaded.org.springframework.context.annotation.MBeanExportConfiguration;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Primary;
import org.qubership.profiler.shaded.org.springframework.core.env.Environment;
import org.qubership.profiler.shaded.org.springframework.jmx.export.MBeanExporter;
import org.qubership.profiler.shaded.org.springframework.jmx.export.annotation.AnnotationJmxAttributeSource;
import org.qubership.profiler.shaded.org.springframework.jmx.export.annotation.AnnotationMBeanExporter;
import org.qubership.profiler.shaded.org.springframework.jmx.export.naming.ObjectNamingStrategy;
import org.qubership.profiler.shaded.org.springframework.jmx.support.MBeanServerFactoryBean;
import org.qubership.profiler.shaded.org.springframework.jmx.support.RegistrationPolicy;
import org.qubership.profiler.shaded.org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={MBeanExporter.class})
@ConditionalOnProperty(prefix="spring.jmx", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class JmxAutoConfiguration
implements EnvironmentAware,
BeanFactoryAware {
    private RelaxedPropertyResolver propertyResolver;
    private BeanFactory beanFactory;

    @Override
    public void setEnvironment(Environment environment) {
        this.propertyResolver = new RelaxedPropertyResolver(environment, "spring.jmx.");
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    @Bean
    @Primary
    @ConditionalOnMissingBean(value={MBeanExporter.class}, search=SearchStrategy.CURRENT)
    public AnnotationMBeanExporter mbeanExporter(ObjectNamingStrategy namingStrategy) {
        AnnotationMBeanExporter exporter = new AnnotationMBeanExporter();
        exporter.setRegistrationPolicy(RegistrationPolicy.FAIL_ON_EXISTING);
        exporter.setNamingStrategy(namingStrategy);
        String server = this.propertyResolver.getProperty("server", "mbeanServer");
        if (StringUtils.hasLength(server)) {
            exporter.setServer(this.beanFactory.getBean(server, MBeanServer.class));
        }
        return exporter;
    }

    @Bean
    @ConditionalOnMissingBean(value={ObjectNamingStrategy.class}, search=SearchStrategy.CURRENT)
    public ParentAwareNamingStrategy objectNamingStrategy() {
        ParentAwareNamingStrategy namingStrategy = new ParentAwareNamingStrategy(new AnnotationJmxAttributeSource());
        String defaultDomain = this.propertyResolver.getProperty("default-domain");
        if (StringUtils.hasLength(defaultDomain)) {
            namingStrategy.setDefaultDomain(defaultDomain);
        }
        return namingStrategy;
    }

    @Bean
    @ConditionalOnMissingBean(value={MBeanServer.class})
    public MBeanServer mbeanServer() {
        MBeanExportConfiguration.SpecificPlatform platform = MBeanExportConfiguration.SpecificPlatform.get();
        if (platform != null) {
            return platform.getMBeanServer();
        }
        MBeanServerFactoryBean factory = new MBeanServerFactoryBean();
        factory.setLocateExistingServerIfPossible(true);
        factory.afterPropertiesSet();
        return factory.getObject();
    }
}

