/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.kafka;

import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.qubership.profiler.shaded.org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.qubership.profiler.shaded.org.springframework.kafka.core.ConsumerFactory;
import org.qubership.profiler.shaded.org.springframework.kafka.listener.config.ContainerProperties;

public class ConcurrentKafkaListenerContainerFactoryConfigurer {
    private KafkaProperties properties;

    void setKafkaProperties(KafkaProperties properties) {
        this.properties = properties;
    }

    public void configure(ConcurrentKafkaListenerContainerFactory<Object, Object> listenerContainerFactory, ConsumerFactory<Object, Object> consumerFactory) {
        listenerContainerFactory.setConsumerFactory(consumerFactory);
        KafkaProperties.Listener container = this.properties.getListener();
        ContainerProperties containerProperties = listenerContainerFactory.getContainerProperties();
        if (container.getAckMode() != null) {
            containerProperties.setAckMode(container.getAckMode());
        }
        if (container.getAckCount() != null) {
            containerProperties.setAckCount(container.getAckCount().intValue());
        }
        if (container.getAckTime() != null) {
            containerProperties.setAckTime(container.getAckTime().longValue());
        }
        if (container.getPollTimeout() != null) {
            containerProperties.setPollTimeout(container.getPollTimeout().longValue());
        }
        if (container.getConcurrency() != null) {
            listenerContainerFactory.setConcurrency(container.getConcurrency());
        }
    }
}

