/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.kafka;

import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.kafka.ConcurrentKafkaListenerContainerFactoryConfigurer;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Bean;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Configuration;
import org.qubership.profiler.shaded.org.springframework.kafka.annotation.EnableKafka;
import org.qubership.profiler.shaded.org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.qubership.profiler.shaded.org.springframework.kafka.core.ConsumerFactory;

@Configuration
@ConditionalOnClass(value={EnableKafka.class})
class KafkaAnnotationDrivenConfiguration {
    private final KafkaProperties properties;

    KafkaAnnotationDrivenConfiguration(KafkaProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    public ConcurrentKafkaListenerContainerFactoryConfigurer kafkaListenerContainerFactoryConfigurer() {
        ConcurrentKafkaListenerContainerFactoryConfigurer configurer = new ConcurrentKafkaListenerContainerFactoryConfigurer();
        configurer.setKafkaProperties(this.properties);
        return configurer;
    }

    @Bean
    @ConditionalOnMissingBean(name={"kafkaListenerContainerFactory"})
    public ConcurrentKafkaListenerContainerFactory<?, ?> kafkaListenerContainerFactory(ConcurrentKafkaListenerContainerFactoryConfigurer configurer, ConsumerFactory<Object, Object> kafkaConsumerFactory) {
        ConcurrentKafkaListenerContainerFactory factory = new ConcurrentKafkaListenerContainerFactory();
        configurer.configure((ConcurrentKafkaListenerContainerFactory<Object, Object>)factory, kafkaConsumerFactory);
        return factory;
    }

    @Configuration
    @EnableKafka
    @ConditionalOnMissingBean(name={"org.qubership.profiler.shaded.org.springframework.kafka.config.internalKafkaListenerAnnotationProcessor"})
    protected static class EnableKafkaConfiguration {
        protected EnableKafkaConfiguration() {
        }
    }
}

