/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.liquibase;

import java.lang.reflect.Method;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import liquibase.exception.LiquibaseException;
import liquibase.integration.spring.SpringLiquibase;
import org.qubership.profiler.shaded.org.springframework.beans.factory.ObjectProvider;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.data.jpa.EntityManagerFactoryDependsOnPostProcessor;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.jdbc.DataSourceBuilder;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.liquibase.LiquibaseDataSource;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.liquibase.LiquibaseProperties;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.qubership.profiler.shaded.org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Bean;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Configuration;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Import;
import org.qubership.profiler.shaded.org.springframework.core.io.Resource;
import org.qubership.profiler.shaded.org.springframework.core.io.ResourceLoader;
import org.qubership.profiler.shaded.org.springframework.orm.jpa.AbstractEntityManagerFactoryBean;
import org.qubership.profiler.shaded.org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.qubership.profiler.shaded.org.springframework.util.Assert;
import org.qubership.profiler.shaded.org.springframework.util.ReflectionUtils;

@Configuration
@ConditionalOnClass(value={SpringLiquibase.class})
@ConditionalOnBean(value={DataSource.class})
@ConditionalOnProperty(prefix="liquibase", name={"enabled"}, matchIfMissing=true)
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class, HibernateJpaAutoConfiguration.class})
public class LiquibaseAutoConfiguration {

    private static final class DataSourceClosingSpringLiquibase
    extends SpringLiquibase {
        private DataSourceClosingSpringLiquibase() {
        }

        public void afterPropertiesSet() throws LiquibaseException {
            super.afterPropertiesSet();
            this.closeDataSource();
        }

        private void closeDataSource() {
            Class<?> dataSourceClass = this.getDataSource().getClass();
            Method closeMethod = ReflectionUtils.findMethod(dataSourceClass, "close");
            if (closeMethod != null) {
                ReflectionUtils.invokeMethod(closeMethod, this.getDataSource());
            }
        }
    }

    @Configuration
    @ConditionalOnClass(value={LocalContainerEntityManagerFactoryBean.class})
    @ConditionalOnBean(value={AbstractEntityManagerFactoryBean.class})
    protected static class LiquibaseJpaDependencyConfiguration
    extends EntityManagerFactoryDependsOnPostProcessor {
        public LiquibaseJpaDependencyConfiguration() {
            super("liquibase");
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={SpringLiquibase.class})
    @EnableConfigurationProperties(value={LiquibaseProperties.class})
    @Import(value={LiquibaseJpaDependencyConfiguration.class})
    public static class LiquibaseConfiguration {
        private final LiquibaseProperties properties;
        private final ResourceLoader resourceLoader;
        private final DataSource dataSource;
        private final DataSource liquibaseDataSource;

        public LiquibaseConfiguration(LiquibaseProperties properties, ResourceLoader resourceLoader, ObjectProvider<DataSource> dataSource, @LiquibaseDataSource ObjectProvider<DataSource> liquibaseDataSource) {
            this.properties = properties;
            this.resourceLoader = resourceLoader;
            this.dataSource = dataSource.getIfUnique();
            this.liquibaseDataSource = liquibaseDataSource.getIfAvailable();
        }

        @PostConstruct
        public void checkChangelogExists() {
            if (this.properties.isCheckChangeLogLocation()) {
                Resource resource = this.resourceLoader.getResource(this.properties.getChangeLog());
                Assert.state(resource.exists(), "Cannot find changelog location: " + resource + " (please add changelog or check your Liquibase configuration)");
            }
        }

        @Bean
        public SpringLiquibase liquibase() {
            SpringLiquibase liquibase = this.createSpringLiquibase();
            liquibase.setChangeLog(this.properties.getChangeLog());
            liquibase.setContexts(this.properties.getContexts());
            liquibase.setDefaultSchema(this.properties.getDefaultSchema());
            liquibase.setDropFirst(this.properties.isDropFirst());
            liquibase.setShouldRun(this.properties.isEnabled());
            liquibase.setLabels(this.properties.getLabels());
            liquibase.setChangeLogParameters(this.properties.getParameters());
            liquibase.setRollbackFile(this.properties.getRollbackFile());
            return liquibase;
        }

        private SpringLiquibase createSpringLiquibase() {
            DataSource liquibaseDataSource = this.getDataSource();
            if (liquibaseDataSource != null) {
                SpringLiquibase liquibase = new SpringLiquibase();
                liquibase.setDataSource(liquibaseDataSource);
                return liquibase;
            }
            DataSourceClosingSpringLiquibase liquibase = new DataSourceClosingSpringLiquibase();
            liquibase.setDataSource(this.createNewDataSource());
            return liquibase;
        }

        private DataSource getDataSource() {
            if (this.liquibaseDataSource != null) {
                return this.liquibaseDataSource;
            }
            if (this.properties.getUrl() == null) {
                return this.dataSource;
            }
            return null;
        }

        private DataSource createNewDataSource() {
            return DataSourceBuilder.create().url(this.properties.getUrl()).username(this.properties.getUser()).password(this.properties.getPassword()).build();
        }
    }
}

