/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.security.oauth2.client;

import javax.servlet.Filter;
import org.qubership.profiler.shaded.org.springframework.beans.factory.ObjectProvider;
import org.qubership.profiler.shaded.org.springframework.beans.factory.annotation.Qualifier;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnNotWebApplication;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.NoneNestedConditions;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.security.SecurityProperties;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2ProtectedResourceDetailsConfiguration;
import org.qubership.profiler.shaded.org.springframework.boot.bind.RelaxedPropertyResolver;
import org.qubership.profiler.shaded.org.springframework.boot.context.properties.ConfigurationProperties;
import org.qubership.profiler.shaded.org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Bean;
import org.qubership.profiler.shaded.org.springframework.context.annotation.ConditionContext;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Conditional;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Configuration;
import org.qubership.profiler.shaded.org.springframework.context.annotation.ConfigurationCondition;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Import;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Primary;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Scope;
import org.qubership.profiler.shaded.org.springframework.context.annotation.ScopedProxyMode;
import org.qubership.profiler.shaded.org.springframework.core.type.AnnotatedTypeMetadata;
import org.qubership.profiler.shaded.org.springframework.security.core.Authentication;
import org.qubership.profiler.shaded.org.springframework.security.core.context.SecurityContextHolder;
import org.qubership.profiler.shaded.org.springframework.security.oauth2.client.DefaultOAuth2ClientContext;
import org.qubership.profiler.shaded.org.springframework.security.oauth2.client.filter.OAuth2ClientContextFilter;
import org.qubership.profiler.shaded.org.springframework.security.oauth2.client.token.AccessTokenRequest;
import org.qubership.profiler.shaded.org.springframework.security.oauth2.client.token.DefaultAccessTokenRequest;
import org.qubership.profiler.shaded.org.springframework.security.oauth2.client.token.grant.client.ClientCredentialsResourceDetails;
import org.qubership.profiler.shaded.org.springframework.security.oauth2.common.DefaultOAuth2AccessToken;
import org.qubership.profiler.shaded.org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.qubership.profiler.shaded.org.springframework.security.oauth2.config.annotation.web.configuration.EnableOAuth2Client;
import org.qubership.profiler.shaded.org.springframework.security.oauth2.config.annotation.web.configuration.OAuth2ClientConfiguration;
import org.qubership.profiler.shaded.org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.qubership.profiler.shaded.org.springframework.security.oauth2.provider.authentication.OAuth2AuthenticationDetails;
import org.qubership.profiler.shaded.org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={EnableOAuth2Client.class})
public class OAuth2RestOperationsConfiguration {

    static class ClientCredentialsCondition
    extends AnyNestedCondition {
        ClientCredentialsCondition() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @ConditionalOnNotWebApplication
        static class NoWebApplication {
            NoWebApplication() {
            }
        }

        @ConditionalOnProperty(prefix="security.oauth2.client", name={"grant-type"}, havingValue="client_credentials", matchIfMissing=false)
        static class ClientCredentialsConfigured {
            ClientCredentialsConfigured() {
            }
        }
    }

    static class NoClientCredentialsCondition
    extends NoneNestedConditions {
        NoClientCredentialsCondition() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @Conditional(value={ClientCredentialsCondition.class})
        static class ClientCredentialsActivated {
            ClientCredentialsActivated() {
            }
        }
    }

    static class OAuth2ClientIdCondition
    extends SpringBootCondition {
        OAuth2ClientIdCondition() {
        }

        @Override
        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            RelaxedPropertyResolver resolver = new RelaxedPropertyResolver(context.getEnvironment(), "security.oauth2.client.");
            String clientId = resolver.getProperty("client-id");
            ConditionMessage.Builder message = ConditionMessage.forCondition("OAuth Client ID", new Object[0]);
            if (StringUtils.hasLength(clientId)) {
                return ConditionOutcome.match(message.foundExactly("security.oauth2.client.client-id property"));
            }
            return ConditionOutcome.noMatch(message.didNotFind("security.oauth2.client.client-id property").atAll());
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={OAuth2ClientConfiguration.class})
    @Conditional(value={OAuth2ClientIdCondition.class, NoClientCredentialsCondition.class})
    @Import(value={OAuth2ProtectedResourceDetailsConfiguration.class})
    protected static class RequestScopedConfiguration {
        protected RequestScopedConfiguration() {
        }

        @Bean
        @Scope(value="request", proxyMode=ScopedProxyMode.INTERFACES)
        public DefaultOAuth2ClientContext oauth2ClientContext() {
            OAuth2Authentication authentication;
            Object details;
            DefaultOAuth2ClientContext context = new DefaultOAuth2ClientContext((AccessTokenRequest)new DefaultAccessTokenRequest());
            Authentication principal = SecurityContextHolder.getContext().getAuthentication();
            if (principal instanceof OAuth2Authentication && (details = (authentication = (OAuth2Authentication)principal).getDetails()) instanceof OAuth2AuthenticationDetails) {
                OAuth2AuthenticationDetails oauthsDetails = (OAuth2AuthenticationDetails)details;
                String token = oauthsDetails.getTokenValue();
                context.setAccessToken((OAuth2AccessToken)new DefaultOAuth2AccessToken(token));
            }
            return context;
        }
    }

    @Configuration
    @ConditionalOnBean(value={OAuth2ClientConfiguration.class})
    @Conditional(value={OAuth2ClientIdCondition.class, NoClientCredentialsCondition.class})
    @Import(value={OAuth2ProtectedResourceDetailsConfiguration.class})
    protected static class SessionScopedConfiguration {
        protected SessionScopedConfiguration() {
        }

        @Bean
        public FilterRegistrationBean oauth2ClientFilterRegistration(OAuth2ClientContextFilter filter, SecurityProperties security) {
            FilterRegistrationBean registration = new FilterRegistrationBean();
            registration.setFilter((Filter)filter);
            registration.setOrder(security.getFilterOrder() - 10);
            return registration;
        }

        @Configuration
        protected static class ClientContextConfiguration {
            private final AccessTokenRequest accessTokenRequest;

            public ClientContextConfiguration(@Qualifier(value="accessTokenRequest") ObjectProvider<AccessTokenRequest> accessTokenRequest) {
                this.accessTokenRequest = accessTokenRequest.getIfAvailable();
            }

            @Bean
            @Scope(value="session", proxyMode=ScopedProxyMode.INTERFACES)
            public DefaultOAuth2ClientContext oauth2ClientContext() {
                return new DefaultOAuth2ClientContext(this.accessTokenRequest);
            }
        }
    }

    @Configuration
    @Conditional(value={ClientCredentialsCondition.class})
    protected static class SingletonScopedConfiguration {
        protected SingletonScopedConfiguration() {
        }

        @Bean
        @ConfigurationProperties(prefix="security.oauth2.client")
        @Primary
        public ClientCredentialsResourceDetails oauth2RemoteResource() {
            ClientCredentialsResourceDetails details = new ClientCredentialsResourceDetails();
            return details;
        }

        @Bean
        public DefaultOAuth2ClientContext oauth2ClientContext() {
            return new DefaultOAuth2ClientContext((AccessTokenRequest)new DefaultAccessTokenRequest());
        }
    }
}

