/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.security.oauth2.client;

import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.security.oauth2.client.EnableOAuth2SsoCondition;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2SsoProperties;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.security.oauth2.client.SsoSecurityConfigurer;
import org.qubership.profiler.shaded.org.springframework.context.ApplicationContext;
import org.qubership.profiler.shaded.org.springframework.context.annotation.ConditionContext;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Conditional;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Configuration;
import org.qubership.profiler.shaded.org.springframework.core.Ordered;
import org.qubership.profiler.shaded.org.springframework.core.type.AnnotatedTypeMetadata;
import org.qubership.profiler.shaded.org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.qubership.profiler.shaded.org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.qubership.profiler.shaded.org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.qubership.profiler.shaded.org.springframework.util.ClassUtils;

@Configuration
@Conditional(value={NeedsWebSecurityCondition.class})
public class OAuth2SsoDefaultConfiguration
extends WebSecurityConfigurerAdapter
implements Ordered {
    private final ApplicationContext applicationContext;
    private final OAuth2SsoProperties sso;

    public OAuth2SsoDefaultConfiguration(ApplicationContext applicationContext, OAuth2SsoProperties sso) {
        this.applicationContext = applicationContext;
        this.sso = sso;
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.antMatcher("/**").authorizeRequests().anyRequest()).authenticated();
        new SsoSecurityConfigurer(this.applicationContext).configure(http);
    }

    @Override
    public int getOrder() {
        if (this.sso.getFilterOrder() != null) {
            return this.sso.getFilterOrder();
        }
        if (ClassUtils.isPresent("org.qubership.profiler.shaded.org.springframework.boot.actuate.autoconfigure.ManagementServerProperties", null)) {
            return 0x7FFFFFF3;
        }
        return 0x7FFFFFF8;
    }

    protected static class NeedsWebSecurityCondition
    extends EnableOAuth2SsoCondition {
        protected NeedsWebSecurityCondition() {
        }

        @Override
        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            return ConditionOutcome.inverse(super.getMatchOutcome(context, metadata));
        }
    }
}

