/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.session;

import javax.sql.DataSource;
import org.qubership.profiler.shaded.org.springframework.beans.factory.annotation.Autowired;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.session.JdbcSessionDatabaseInitializer;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.session.SessionCondition;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.session.SessionProperties;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Bean;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Conditional;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Configuration;
import org.qubership.profiler.shaded.org.springframework.core.io.ResourceLoader;
import org.qubership.profiler.shaded.org.springframework.jdbc.core.JdbcTemplate;
import org.qubership.profiler.shaded.org.springframework.session.SessionRepository;
import org.qubership.profiler.shaded.org.springframework.session.jdbc.config.annotation.web.http.JdbcHttpSessionConfiguration;

@Configuration
@ConditionalOnClass(value={JdbcTemplate.class})
@ConditionalOnMissingBean(value={SessionRepository.class})
@ConditionalOnBean(value={DataSource.class})
@Conditional(value={SessionCondition.class})
class JdbcSessionConfiguration {
    JdbcSessionConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    public JdbcSessionDatabaseInitializer jdbcSessionDatabaseInitializer(DataSource dataSource, ResourceLoader resourceLoader, SessionProperties properties) {
        return new JdbcSessionDatabaseInitializer(dataSource, resourceLoader, properties);
    }

    @Configuration
    public static class SpringBootJdbcHttpSessionConfiguration
    extends JdbcHttpSessionConfiguration {
        @Autowired
        public void customize(SessionProperties sessionProperties) {
            Integer timeout = sessionProperties.getTimeout();
            if (timeout != null) {
                this.setMaxInactiveIntervalInSeconds(timeout);
            }
            this.setTableName(sessionProperties.getJdbc().getTableName());
        }
    }
}

