/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.session;

import java.util.Locale;
import javax.annotation.PostConstruct;
import org.qubership.profiler.shaded.org.springframework.beans.factory.ObjectProvider;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.hazelcast.HazelcastAutoConfiguration;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.jdbc.JdbcTemplateAutoConfiguration;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.mongo.MongoAutoConfiguration;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.session.SessionProperties;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.session.SessionStoreMappings;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.session.StoreType;
import org.qubership.profiler.shaded.org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Configuration;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Import;
import org.qubership.profiler.shaded.org.springframework.context.annotation.ImportSelector;
import org.qubership.profiler.shaded.org.springframework.core.type.AnnotationMetadata;
import org.qubership.profiler.shaded.org.springframework.session.Session;
import org.qubership.profiler.shaded.org.springframework.session.SessionRepository;

@Configuration
@ConditionalOnMissingBean(value={SessionRepository.class})
@ConditionalOnClass(value={Session.class})
@ConditionalOnWebApplication
@EnableConfigurationProperties(value={SessionProperties.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class, HazelcastAutoConfiguration.class, JdbcTemplateAutoConfiguration.class, MongoAutoConfiguration.class, RedisAutoConfiguration.class})
@Import(value={SessionConfigurationImportSelector.class, SessionRepositoryValidator.class})
public class SessionAutoConfiguration {

    static class SessionRepositoryValidator {
        private SessionProperties sessionProperties;
        private ObjectProvider<SessionRepository<?>> sessionRepositoryProvider;

        SessionRepositoryValidator(SessionProperties sessionProperties, ObjectProvider<SessionRepository<?>> sessionRepositoryProvider) {
            this.sessionProperties = sessionProperties;
            this.sessionRepositoryProvider = sessionRepositoryProvider;
        }

        @PostConstruct
        public void checkSessionRepository() {
            StoreType storeType = this.sessionProperties.getStoreType();
            if (storeType != StoreType.NONE && this.sessionRepositoryProvider.getIfAvailable() == null) {
                if (storeType != null) {
                    throw new IllegalArgumentException("No session repository could be auto-configured, check your configuration (session store type is '" + storeType.name().toLowerCase(Locale.ENGLISH) + "')");
                }
                throw new IllegalArgumentException("No Spring Session store is configured: set the 'spring.session.store-type' property");
            }
        }
    }

    static class SessionConfigurationImportSelector
    implements ImportSelector {
        SessionConfigurationImportSelector() {
        }

        @Override
        public String[] selectImports(AnnotationMetadata importingClassMetadata) {
            StoreType[] types = StoreType.values();
            String[] imports = new String[types.length];
            for (int i = 0; i < types.length; ++i) {
                imports[i] = SessionStoreMappings.getConfigurationClass(types[i]);
            }
            return imports;
        }
    }
}

