/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.social;

import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.social.LinkedInProperties;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.social.SocialAutoConfigurerAdapter;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.social.SocialWebAutoConfiguration;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration;
import org.qubership.profiler.shaded.org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Bean;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Configuration;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Scope;
import org.qubership.profiler.shaded.org.springframework.context.annotation.ScopedProxyMode;
import org.qubership.profiler.shaded.org.springframework.social.config.annotation.EnableSocial;
import org.qubership.profiler.shaded.org.springframework.social.config.annotation.SocialConfigurerAdapter;
import org.qubership.profiler.shaded.org.springframework.social.connect.Connection;
import org.qubership.profiler.shaded.org.springframework.social.connect.ConnectionFactory;
import org.qubership.profiler.shaded.org.springframework.social.connect.ConnectionRepository;
import org.qubership.profiler.shaded.org.springframework.social.connect.web.GenericConnectionStatusView;
import org.qubership.profiler.shaded.org.springframework.social.linkedin.api.LinkedIn;
import org.qubership.profiler.shaded.org.springframework.social.linkedin.connect.LinkedInConnectionFactory;

@Configuration
@ConditionalOnClass(value={SocialConfigurerAdapter.class, LinkedInConnectionFactory.class})
@ConditionalOnProperty(prefix="spring.social.linkedin", name={"app-id"})
@AutoConfigureBefore(value={SocialWebAutoConfiguration.class})
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class})
public class LinkedInAutoConfiguration {

    @Configuration
    @EnableSocial
    @EnableConfigurationProperties(value={LinkedInProperties.class})
    @ConditionalOnWebApplication
    protected static class LinkedInConfigurerAdapter
    extends SocialAutoConfigurerAdapter {
        private final LinkedInProperties properties;

        protected LinkedInConfigurerAdapter(LinkedInProperties properties) {
            this.properties = properties;
        }

        @Bean
        @ConditionalOnMissingBean(value={LinkedIn.class})
        @Scope(value="request", proxyMode=ScopedProxyMode.INTERFACES)
        public LinkedIn linkedin(ConnectionRepository repository) {
            Connection connection = repository.findPrimaryConnection(LinkedIn.class);
            return connection != null ? (LinkedIn)connection.getApi() : null;
        }

        @Bean(name={"connect/linkedinConnect", "connect/linkedinConnected"})
        @ConditionalOnProperty(prefix="spring.social", name={"auto-connection-views"})
        public GenericConnectionStatusView linkedInConnectView() {
            return new GenericConnectionStatusView("linkedin", "LinkedIn");
        }

        @Override
        protected ConnectionFactory<?> createConnectionFactory() {
            return new LinkedInConnectionFactory(this.properties.getAppId(), this.properties.getAppSecret());
        }
    }
}

