/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.social;

import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.social.SocialAutoConfigurerAdapter;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.social.SocialWebAutoConfiguration;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.social.TwitterProperties;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration;
import org.qubership.profiler.shaded.org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Bean;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Configuration;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Scope;
import org.qubership.profiler.shaded.org.springframework.context.annotation.ScopedProxyMode;
import org.qubership.profiler.shaded.org.springframework.social.config.annotation.EnableSocial;
import org.qubership.profiler.shaded.org.springframework.social.config.annotation.SocialConfigurerAdapter;
import org.qubership.profiler.shaded.org.springframework.social.connect.Connection;
import org.qubership.profiler.shaded.org.springframework.social.connect.ConnectionFactory;
import org.qubership.profiler.shaded.org.springframework.social.connect.ConnectionRepository;
import org.qubership.profiler.shaded.org.springframework.social.connect.web.GenericConnectionStatusView;
import org.qubership.profiler.shaded.org.springframework.social.twitter.api.Twitter;
import org.qubership.profiler.shaded.org.springframework.social.twitter.api.impl.TwitterTemplate;
import org.qubership.profiler.shaded.org.springframework.social.twitter.connect.TwitterConnectionFactory;

@Configuration
@ConditionalOnClass(value={SocialConfigurerAdapter.class, TwitterConnectionFactory.class})
@ConditionalOnProperty(prefix="spring.social.twitter", name={"app-id"})
@AutoConfigureBefore(value={SocialWebAutoConfiguration.class})
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class})
public class TwitterAutoConfiguration {

    @Configuration
    @EnableSocial
    @EnableConfigurationProperties(value={TwitterProperties.class})
    @ConditionalOnWebApplication
    protected static class TwitterConfigurerAdapter
    extends SocialAutoConfigurerAdapter {
        private final TwitterProperties properties;

        protected TwitterConfigurerAdapter(TwitterProperties properties) {
            this.properties = properties;
        }

        @Bean
        @ConditionalOnMissingBean
        @Scope(value="request", proxyMode=ScopedProxyMode.INTERFACES)
        public Twitter twitter(ConnectionRepository repository) {
            Connection connection = repository.findPrimaryConnection(Twitter.class);
            if (connection != null) {
                return (Twitter)connection.getApi();
            }
            return new TwitterTemplate(this.properties.getAppId(), this.properties.getAppSecret());
        }

        @Bean(name={"connect/twitterConnect", "connect/twitterConnected"})
        @ConditionalOnProperty(prefix="spring.social", name={"auto-connection-views"})
        public GenericConnectionStatusView twitterConnectView() {
            return new GenericConnectionStatusView("twitter", "Twitter");
        }

        @Override
        protected ConnectionFactory<?> createConnectionFactory() {
            return new TwitterConnectionFactory(this.properties.getAppId(), this.properties.getAppSecret());
        }
    }
}

