/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.validation;

import javax.validation.Validator;
import javax.validation.executable.ExecutableValidator;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.validation.PrimaryDefaultValidatorPostProcessor;
import org.qubership.profiler.shaded.org.springframework.boot.bind.RelaxedPropertyResolver;
import org.qubership.profiler.shaded.org.springframework.boot.validation.MessageInterpolatorFactory;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Bean;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Configuration;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Import;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Lazy;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Role;
import org.qubership.profiler.shaded.org.springframework.core.env.Environment;
import org.qubership.profiler.shaded.org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;
import org.qubership.profiler.shaded.org.springframework.validation.beanvalidation.MethodValidationPostProcessor;

@Configuration
@ConditionalOnClass(value={ExecutableValidator.class})
@ConditionalOnResource(resources={"classpath:META-INF/services/javax.validation.spi.ValidationProvider"})
@Import(value={PrimaryDefaultValidatorPostProcessor.class})
public class ValidationAutoConfiguration {
    @Bean
    @Role(value=2)
    @ConditionalOnMissingBean(value={Validator.class})
    public static LocalValidatorFactoryBean defaultValidator() {
        LocalValidatorFactoryBean factoryBean = new LocalValidatorFactoryBean();
        MessageInterpolatorFactory interpolatorFactory = new MessageInterpolatorFactory();
        factoryBean.setMessageInterpolator(interpolatorFactory.getObject());
        return factoryBean;
    }

    @Bean
    @ConditionalOnMissingBean
    public static MethodValidationPostProcessor methodValidationPostProcessor(Environment environment, @Lazy Validator validator) {
        MethodValidationPostProcessor processor = new MethodValidationPostProcessor();
        processor.setProxyTargetClass(ValidationAutoConfiguration.determineProxyTargetClass(environment));
        processor.setValidator(validator);
        return processor;
    }

    private static boolean determineProxyTargetClass(Environment environment) {
        RelaxedPropertyResolver resolver = new RelaxedPropertyResolver(environment, "spring.aop.");
        Boolean value = resolver.getProperty("proxyTargetClass", Boolean.class);
        return value != null ? value : true;
    }
}

