/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.web;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.web.AbstractErrorController;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.web.ErrorAttributes;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.web.ErrorProperties;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.web.ErrorViewResolver;
import org.qubership.profiler.shaded.org.springframework.http.HttpStatus;
import org.qubership.profiler.shaded.org.springframework.http.MediaType;
import org.qubership.profiler.shaded.org.springframework.http.ResponseEntity;
import org.qubership.profiler.shaded.org.springframework.stereotype.Controller;
import org.qubership.profiler.shaded.org.springframework.util.Assert;
import org.qubership.profiler.shaded.org.springframework.web.bind.annotation.RequestMapping;
import org.qubership.profiler.shaded.org.springframework.web.bind.annotation.ResponseBody;
import org.qubership.profiler.shaded.org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"${server.error.path:${error.path:/error}}"})
public class BasicErrorController
extends AbstractErrorController {
    private final ErrorProperties errorProperties;

    public BasicErrorController(ErrorAttributes errorAttributes, ErrorProperties errorProperties) {
        this(errorAttributes, errorProperties, Collections.emptyList());
    }

    public BasicErrorController(ErrorAttributes errorAttributes, ErrorProperties errorProperties, List<ErrorViewResolver> errorViewResolvers) {
        super(errorAttributes, errorViewResolvers);
        Assert.notNull(errorProperties, "ErrorProperties must not be null");
        this.errorProperties = errorProperties;
    }

    @Override
    public String getErrorPath() {
        return this.errorProperties.getPath();
    }

    @RequestMapping(produces={"text/html"})
    public ModelAndView errorHtml(HttpServletRequest request, HttpServletResponse response) {
        HttpStatus status = this.getStatus(request);
        Map<String, Object> model = Collections.unmodifiableMap(this.getErrorAttributes(request, this.isIncludeStackTrace(request, MediaType.TEXT_HTML)));
        response.setStatus(status.value());
        ModelAndView modelAndView = this.resolveErrorView(request, response, status, model);
        return modelAndView != null ? modelAndView : new ModelAndView("error", model);
    }

    @RequestMapping
    @ResponseBody
    public ResponseEntity<Map<String, Object>> error(HttpServletRequest request) {
        Map<String, Object> body = this.getErrorAttributes(request, this.isIncludeStackTrace(request, MediaType.ALL));
        HttpStatus status = this.getStatus(request);
        return new ResponseEntity(body, status);
    }

    protected boolean isIncludeStackTrace(HttpServletRequest request, MediaType produces) {
        ErrorProperties.IncludeStacktrace include = this.getErrorProperties().getIncludeStacktrace();
        if (include == ErrorProperties.IncludeStacktrace.ALWAYS) {
            return true;
        }
        if (include == ErrorProperties.IncludeStacktrace.ON_TRACE_PARAM) {
            return this.getTraceParameter(request);
        }
        return false;
    }

    protected ErrorProperties getErrorProperties() {
        return this.errorProperties;
    }
}

