/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.web;

import org.qubership.profiler.shaded.org.springframework.beans.BeansException;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.web.ServerProperties;
import org.qubership.profiler.shaded.org.springframework.boot.context.embedded.ConfigurableEmbeddedServletContainer;
import org.qubership.profiler.shaded.org.springframework.boot.context.embedded.EmbeddedServletContainerCustomizer;
import org.qubership.profiler.shaded.org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.qubership.profiler.shaded.org.springframework.context.ApplicationContext;
import org.qubership.profiler.shaded.org.springframework.context.ApplicationContextAware;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Bean;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Configuration;
import org.qubership.profiler.shaded.org.springframework.core.Ordered;
import org.qubership.profiler.shaded.org.springframework.util.Assert;
import org.qubership.profiler.shaded.org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties
@ConditionalOnWebApplication
public class ServerPropertiesAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(search=SearchStrategy.CURRENT)
    public ServerProperties serverProperties() {
        return new ServerProperties();
    }

    @Bean
    public DuplicateServerPropertiesDetector duplicateServerPropertiesDetector() {
        return new DuplicateServerPropertiesDetector();
    }

    private static class DuplicateServerPropertiesDetector
    implements EmbeddedServletContainerCustomizer,
    Ordered,
    ApplicationContextAware {
        private ApplicationContext applicationContext;

        private DuplicateServerPropertiesDetector() {
        }

        @Override
        public int getOrder() {
            return 0;
        }

        @Override
        public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
            this.applicationContext = applicationContext;
        }

        @Override
        public void customize(ConfigurableEmbeddedServletContainer container) {
            Object[] serverPropertiesBeans = this.applicationContext.getBeanNamesForType(ServerProperties.class);
            Assert.state(serverPropertiesBeans.length != 0, "No ServerProperties registered");
            Assert.state(serverPropertiesBeans.length == 1, "Multiple ServerProperties registered " + StringUtils.arrayToCommaDelimitedString(serverPropertiesBeans));
        }
    }
}

