/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.web;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import org.qubership.profiler.shaded.org.apache.commons.logging.Log;
import org.qubership.profiler.shaded.org.apache.commons.logging.LogFactory;
import org.qubership.profiler.shaded.org.springframework.beans.factory.BeanFactory;
import org.qubership.profiler.shaded.org.springframework.beans.factory.ListableBeanFactory;
import org.qubership.profiler.shaded.org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.qubership.profiler.shaded.org.springframework.beans.factory.ObjectProvider;
import org.qubership.profiler.shaded.org.springframework.beans.factory.annotation.Autowired;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.validation.ValidationAutoConfiguration;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.web.ConditionalOnEnabledResourceChain;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.web.DispatcherServletAutoConfiguration;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.web.HttpMessageConverters;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.web.ResourceProperties;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.web.WebMvcProperties;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.web.WebMvcRegistrations;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.web.WebMvcValidator;
import org.qubership.profiler.shaded.org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.qubership.profiler.shaded.org.springframework.boot.web.filter.OrderedHiddenHttpMethodFilter;
import org.qubership.profiler.shaded.org.springframework.boot.web.filter.OrderedHttpPutFormContentFilter;
import org.qubership.profiler.shaded.org.springframework.boot.web.filter.OrderedRequestContextFilter;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Bean;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Configuration;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Import;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Lazy;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Primary;
import org.qubership.profiler.shaded.org.springframework.core.convert.converter.Converter;
import org.qubership.profiler.shaded.org.springframework.core.convert.converter.GenericConverter;
import org.qubership.profiler.shaded.org.springframework.core.io.Resource;
import org.qubership.profiler.shaded.org.springframework.format.Formatter;
import org.qubership.profiler.shaded.org.springframework.format.FormatterRegistry;
import org.qubership.profiler.shaded.org.springframework.format.datetime.DateFormatter;
import org.qubership.profiler.shaded.org.springframework.http.MediaType;
import org.qubership.profiler.shaded.org.springframework.http.converter.HttpMessageConverter;
import org.qubership.profiler.shaded.org.springframework.util.ClassUtils;
import org.qubership.profiler.shaded.org.springframework.util.StringUtils;
import org.qubership.profiler.shaded.org.springframework.validation.DefaultMessageCodesResolver;
import org.qubership.profiler.shaded.org.springframework.validation.MessageCodesResolver;
import org.qubership.profiler.shaded.org.springframework.validation.Validator;
import org.qubership.profiler.shaded.org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.qubership.profiler.shaded.org.springframework.web.accept.ContentNegotiationManager;
import org.qubership.profiler.shaded.org.springframework.web.accept.ContentNegotiationStrategy;
import org.qubership.profiler.shaded.org.springframework.web.accept.PathExtensionContentNegotiationStrategy;
import org.qubership.profiler.shaded.org.springframework.web.bind.support.ConfigurableWebBindingInitializer;
import org.qubership.profiler.shaded.org.springframework.web.context.request.NativeWebRequest;
import org.qubership.profiler.shaded.org.springframework.web.context.request.RequestContextListener;
import org.qubership.profiler.shaded.org.springframework.web.filter.HiddenHttpMethodFilter;
import org.qubership.profiler.shaded.org.springframework.web.filter.HttpPutFormContentFilter;
import org.qubership.profiler.shaded.org.springframework.web.filter.RequestContextFilter;
import org.qubership.profiler.shaded.org.springframework.web.servlet.DispatcherServlet;
import org.qubership.profiler.shaded.org.springframework.web.servlet.HandlerExceptionResolver;
import org.qubership.profiler.shaded.org.springframework.web.servlet.LocaleResolver;
import org.qubership.profiler.shaded.org.springframework.web.servlet.View;
import org.qubership.profiler.shaded.org.springframework.web.servlet.ViewResolver;
import org.qubership.profiler.shaded.org.springframework.web.servlet.config.annotation.AsyncSupportConfigurer;
import org.qubership.profiler.shaded.org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import org.qubership.profiler.shaded.org.springframework.web.servlet.config.annotation.DelegatingWebMvcConfiguration;
import org.qubership.profiler.shaded.org.springframework.web.servlet.config.annotation.ResourceChainRegistration;
import org.qubership.profiler.shaded.org.springframework.web.servlet.config.annotation.ResourceHandlerRegistration;
import org.qubership.profiler.shaded.org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.qubership.profiler.shaded.org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;
import org.qubership.profiler.shaded.org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.qubership.profiler.shaded.org.springframework.web.servlet.handler.AbstractHandlerExceptionResolver;
import org.qubership.profiler.shaded.org.springframework.web.servlet.handler.AbstractUrlHandlerMapping;
import org.qubership.profiler.shaded.org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import org.qubership.profiler.shaded.org.springframework.web.servlet.i18n.AcceptHeaderLocaleResolver;
import org.qubership.profiler.shaded.org.springframework.web.servlet.i18n.FixedLocaleResolver;
import org.qubership.profiler.shaded.org.springframework.web.servlet.mvc.ParameterizableViewController;
import org.qubership.profiler.shaded.org.springframework.web.servlet.mvc.method.annotation.ExceptionHandlerExceptionResolver;
import org.qubership.profiler.shaded.org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.qubership.profiler.shaded.org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.qubership.profiler.shaded.org.springframework.web.servlet.resource.AppCacheManifestTransformer;
import org.qubership.profiler.shaded.org.springframework.web.servlet.resource.GzipResourceResolver;
import org.qubership.profiler.shaded.org.springframework.web.servlet.resource.ResourceHttpRequestHandler;
import org.qubership.profiler.shaded.org.springframework.web.servlet.resource.ResourceResolver;
import org.qubership.profiler.shaded.org.springframework.web.servlet.resource.ResourceTransformer;
import org.qubership.profiler.shaded.org.springframework.web.servlet.resource.VersionResourceResolver;
import org.qubership.profiler.shaded.org.springframework.web.servlet.view.BeanNameViewResolver;
import org.qubership.profiler.shaded.org.springframework.web.servlet.view.ContentNegotiatingViewResolver;
import org.qubership.profiler.shaded.org.springframework.web.servlet.view.InternalResourceViewResolver;

@Configuration
@ConditionalOnWebApplication
@ConditionalOnClass(value={Servlet.class, DispatcherServlet.class, WebMvcConfigurerAdapter.class})
@ConditionalOnMissingBean(value={WebMvcConfigurationSupport.class})
@AutoConfigureOrder(value=-2147483638)
@AutoConfigureAfter(value={DispatcherServletAutoConfiguration.class, ValidationAutoConfiguration.class})
public class WebMvcAutoConfiguration {
    public static final String DEFAULT_PREFIX = "";
    public static final String DEFAULT_SUFFIX = "";

    @Bean
    @ConditionalOnMissingBean(value={HiddenHttpMethodFilter.class})
    public OrderedHiddenHttpMethodFilter hiddenHttpMethodFilter() {
        return new OrderedHiddenHttpMethodFilter();
    }

    @Bean
    @ConditionalOnMissingBean(value={HttpPutFormContentFilter.class})
    @ConditionalOnProperty(prefix="spring.mvc.formcontent.putfilter", name={"enabled"}, matchIfMissing=true)
    public OrderedHttpPutFormContentFilter httpPutFormContentFilter() {
        return new OrderedHttpPutFormContentFilter();
    }

    static class OptionalPathExtensionContentNegotiationStrategy
    implements ContentNegotiationStrategy {
        private static final String SKIP_ATTRIBUTE = PathExtensionContentNegotiationStrategy.class.getName() + ".SKIP";
        private final ContentNegotiationStrategy delegate;

        OptionalPathExtensionContentNegotiationStrategy(ContentNegotiationStrategy delegate) {
            this.delegate = delegate;
        }

        public List<MediaType> resolveMediaTypes(NativeWebRequest webRequest) throws HttpMediaTypeNotAcceptableException {
            Object skip = webRequest.getAttribute(SKIP_ATTRIBUTE, 0);
            if (skip != null && Boolean.parseBoolean(skip.toString())) {
                return Collections.emptyList();
            }
            return this.delegate.resolveMediaTypes(webRequest);
        }
    }

    static final class WelcomePageHandlerMapping
    extends AbstractUrlHandlerMapping {
        private static final Log logger = LogFactory.getLog(WelcomePageHandlerMapping.class);

        private WelcomePageHandlerMapping(Resource welcomePage, String staticPathPattern) {
            if (welcomePage != null && "/**".equals(staticPathPattern)) {
                logger.info("Adding welcome page: " + welcomePage);
                ParameterizableViewController controller = new ParameterizableViewController();
                controller.setViewName("forward:index.html");
                this.setRootHandler(controller);
                this.setOrder(0);
            }
        }

        public Object getHandlerInternal(HttpServletRequest request) throws Exception {
            for (MediaType mediaType : this.getAcceptedMediaTypes(request)) {
                if (!mediaType.includes(MediaType.TEXT_HTML)) continue;
                return super.getHandlerInternal(request);
            }
            return null;
        }

        private List<MediaType> getAcceptedMediaTypes(HttpServletRequest request) {
            String acceptHeader = request.getHeader("Accept");
            return MediaType.parseMediaTypes((String)(StringUtils.hasText(acceptHeader) ? acceptHeader : "*/*"));
        }
    }

    private static class ResourceChainResourceHandlerRegistrationCustomizer
    implements ResourceHandlerRegistrationCustomizer {
        @Autowired
        private ResourceProperties resourceProperties = new ResourceProperties();

        private ResourceChainResourceHandlerRegistrationCustomizer() {
        }

        @Override
        public void customize(ResourceHandlerRegistration registration) {
            ResourceProperties.Chain properties = this.resourceProperties.getChain();
            this.configureResourceChain(properties, registration.resourceChain(properties.isCache()));
        }

        private void configureResourceChain(ResourceProperties.Chain properties, ResourceChainRegistration chain) {
            ResourceProperties.Strategy strategy = properties.getStrategy();
            if (strategy.getFixed().isEnabled() || strategy.getContent().isEnabled()) {
                chain.addResolver(this.getVersionResourceResolver(strategy));
            }
            if (properties.isGzipped()) {
                chain.addResolver((ResourceResolver)new GzipResourceResolver());
            }
            if (properties.isHtmlApplicationCache()) {
                chain.addTransformer((ResourceTransformer)new AppCacheManifestTransformer());
            }
        }

        private ResourceResolver getVersionResourceResolver(ResourceProperties.Strategy properties) {
            VersionResourceResolver resolver = new VersionResourceResolver();
            if (properties.getFixed().isEnabled()) {
                String version = properties.getFixed().getVersion();
                String[] paths = properties.getFixed().getPaths();
                resolver.addFixedVersionStrategy(version, paths);
            }
            if (properties.getContent().isEnabled()) {
                String[] paths = properties.getContent().getPaths();
                resolver.addContentVersionStrategy(paths);
            }
            return resolver;
        }
    }

    static interface ResourceHandlerRegistrationCustomizer {
        public void customize(ResourceHandlerRegistration var1);
    }

    @Configuration
    @ConditionalOnEnabledResourceChain
    static class ResourceChainCustomizerConfiguration {
        ResourceChainCustomizerConfiguration() {
        }

        @Bean
        public ResourceChainResourceHandlerRegistrationCustomizer resourceHandlerRegistrationCustomizer() {
            return new ResourceChainResourceHandlerRegistrationCustomizer();
        }
    }

    @Configuration
    public static class EnableWebMvcConfiguration
    extends DelegatingWebMvcConfiguration {
        private final WebMvcProperties mvcProperties;
        private final ListableBeanFactory beanFactory;
        private final WebMvcRegistrations mvcRegistrations;

        public EnableWebMvcConfiguration(ObjectProvider<WebMvcProperties> mvcPropertiesProvider, ObjectProvider<WebMvcRegistrations> mvcRegistrationsProvider, ListableBeanFactory beanFactory) {
            this.mvcProperties = mvcPropertiesProvider.getIfAvailable();
            this.mvcRegistrations = mvcRegistrationsProvider.getIfUnique();
            this.beanFactory = beanFactory;
        }

        @Bean
        public RequestMappingHandlerAdapter requestMappingHandlerAdapter() {
            RequestMappingHandlerAdapter adapter = super.requestMappingHandlerAdapter();
            adapter.setIgnoreDefaultModelOnRedirect(this.mvcProperties != null ? this.mvcProperties.isIgnoreDefaultModelOnRedirect() : true);
            return adapter;
        }

        protected RequestMappingHandlerAdapter createRequestMappingHandlerAdapter() {
            if (this.mvcRegistrations != null && this.mvcRegistrations.getRequestMappingHandlerAdapter() != null) {
                return this.mvcRegistrations.getRequestMappingHandlerAdapter();
            }
            return super.createRequestMappingHandlerAdapter();
        }

        @Bean
        @Primary
        public RequestMappingHandlerMapping requestMappingHandlerMapping() {
            return super.requestMappingHandlerMapping();
        }

        @Bean
        public Validator mvcValidator() {
            if (!ClassUtils.isPresent("javax.validation.Validator", ((Object)((Object)this)).getClass().getClassLoader())) {
                return super.mvcValidator();
            }
            return WebMvcValidator.get(this.getApplicationContext(), this.getValidator());
        }

        protected RequestMappingHandlerMapping createRequestMappingHandlerMapping() {
            if (this.mvcRegistrations != null && this.mvcRegistrations.getRequestMappingHandlerMapping() != null) {
                return this.mvcRegistrations.getRequestMappingHandlerMapping();
            }
            return super.createRequestMappingHandlerMapping();
        }

        protected ConfigurableWebBindingInitializer getConfigurableWebBindingInitializer() {
            try {
                return this.beanFactory.getBean(ConfigurableWebBindingInitializer.class);
            }
            catch (NoSuchBeanDefinitionException ex) {
                return super.getConfigurableWebBindingInitializer();
            }
        }

        protected ExceptionHandlerExceptionResolver createExceptionHandlerExceptionResolver() {
            if (this.mvcRegistrations != null && this.mvcRegistrations.getExceptionHandlerExceptionResolver() != null) {
                return this.mvcRegistrations.getExceptionHandlerExceptionResolver();
            }
            return super.createExceptionHandlerExceptionResolver();
        }

        protected void configureHandlerExceptionResolvers(List<HandlerExceptionResolver> exceptionResolvers) {
            super.configureHandlerExceptionResolvers(exceptionResolvers);
            if (exceptionResolvers.isEmpty()) {
                this.addDefaultHandlerExceptionResolvers(exceptionResolvers);
            }
            if (this.mvcProperties.isLogResolvedException()) {
                for (HandlerExceptionResolver resolver : exceptionResolvers) {
                    if (!(resolver instanceof AbstractHandlerExceptionResolver)) continue;
                    ((AbstractHandlerExceptionResolver)resolver).setWarnLogCategory(resolver.getClass().getName());
                }
            }
        }

        @Bean
        public ContentNegotiationManager mvcContentNegotiationManager() {
            ContentNegotiationManager manager = super.mvcContentNegotiationManager();
            List strategies = manager.getStrategies();
            ListIterator<OptionalPathExtensionContentNegotiationStrategy> iterator = strategies.listIterator();
            while (iterator.hasNext()) {
                ContentNegotiationStrategy strategy = (ContentNegotiationStrategy)iterator.next();
                if (!(strategy instanceof PathExtensionContentNegotiationStrategy)) continue;
                iterator.set(new OptionalPathExtensionContentNegotiationStrategy(strategy));
            }
            return manager;
        }
    }

    @Configuration
    @Import(value={EnableWebMvcConfiguration.class})
    @EnableConfigurationProperties(value={WebMvcProperties.class, ResourceProperties.class})
    public static class WebMvcAutoConfigurationAdapter
    extends WebMvcConfigurerAdapter {
        private static final Log logger = LogFactory.getLog(WebMvcConfigurerAdapter.class);
        private final ResourceProperties resourceProperties;
        private final WebMvcProperties mvcProperties;
        private final ListableBeanFactory beanFactory;
        private final HttpMessageConverters messageConverters;
        final ResourceHandlerRegistrationCustomizer resourceHandlerRegistrationCustomizer;

        public WebMvcAutoConfigurationAdapter(ResourceProperties resourceProperties, WebMvcProperties mvcProperties, ListableBeanFactory beanFactory, @Lazy HttpMessageConverters messageConverters, ObjectProvider<ResourceHandlerRegistrationCustomizer> resourceHandlerRegistrationCustomizerProvider) {
            this.resourceProperties = resourceProperties;
            this.mvcProperties = mvcProperties;
            this.beanFactory = beanFactory;
            this.messageConverters = messageConverters;
            this.resourceHandlerRegistrationCustomizer = resourceHandlerRegistrationCustomizerProvider.getIfAvailable();
        }

        public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
            converters.addAll(this.messageConverters.getConverters());
        }

        public void configureAsyncSupport(AsyncSupportConfigurer configurer) {
            Long timeout = this.mvcProperties.getAsync().getRequestTimeout();
            if (timeout != null) {
                configurer.setDefaultTimeout(timeout.longValue());
            }
        }

        public void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
            Map<String, MediaType> mediaTypes = this.mvcProperties.getMediaTypes();
            for (Map.Entry<String, MediaType> mediaType : mediaTypes.entrySet()) {
                configurer.mediaType(mediaType.getKey(), mediaType.getValue());
            }
        }

        @Bean
        @ConditionalOnMissingBean
        public InternalResourceViewResolver defaultViewResolver() {
            InternalResourceViewResolver resolver = new InternalResourceViewResolver();
            resolver.setPrefix(this.mvcProperties.getView().getPrefix());
            resolver.setSuffix(this.mvcProperties.getView().getSuffix());
            return resolver;
        }

        @Bean
        @ConditionalOnBean(value={View.class})
        @ConditionalOnMissingBean
        public BeanNameViewResolver beanNameViewResolver() {
            BeanNameViewResolver resolver = new BeanNameViewResolver();
            resolver.setOrder(0x7FFFFFF5);
            return resolver;
        }

        @Bean
        @ConditionalOnBean(value={ViewResolver.class})
        @ConditionalOnMissingBean(name={"viewResolver"}, value={ContentNegotiatingViewResolver.class})
        public ContentNegotiatingViewResolver viewResolver(BeanFactory beanFactory) {
            ContentNegotiatingViewResolver resolver = new ContentNegotiatingViewResolver();
            resolver.setContentNegotiationManager(beanFactory.getBean(ContentNegotiationManager.class));
            resolver.setOrder(Integer.MIN_VALUE);
            return resolver;
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="spring.mvc", name={"locale"})
        public LocaleResolver localeResolver() {
            if (this.mvcProperties.getLocaleResolver() == WebMvcProperties.LocaleResolver.FIXED) {
                return new FixedLocaleResolver(this.mvcProperties.getLocale());
            }
            AcceptHeaderLocaleResolver localeResolver = new AcceptHeaderLocaleResolver();
            localeResolver.setDefaultLocale(this.mvcProperties.getLocale());
            return localeResolver;
        }

        @Bean
        @ConditionalOnProperty(prefix="spring.mvc", name={"date-format"})
        public Formatter<Date> dateFormatter() {
            return new DateFormatter(this.mvcProperties.getDateFormat());
        }

        public MessageCodesResolver getMessageCodesResolver() {
            if (this.mvcProperties.getMessageCodesResolverFormat() != null) {
                DefaultMessageCodesResolver resolver = new DefaultMessageCodesResolver();
                resolver.setMessageCodeFormatter(this.mvcProperties.getMessageCodesResolverFormat());
                return resolver;
            }
            return null;
        }

        public void addFormatters(FormatterRegistry registry) {
            for (Converter converter : this.getBeansOfType(Converter.class)) {
                registry.addConverter(converter);
            }
            for (GenericConverter genericConverter : this.getBeansOfType(GenericConverter.class)) {
                registry.addConverter(genericConverter);
            }
            for (Formatter formatter : this.getBeansOfType(Formatter.class)) {
                registry.addFormatter(formatter);
            }
        }

        private <T> Collection<T> getBeansOfType(Class<T> type) {
            return this.beanFactory.getBeansOfType(type).values();
        }

        public void addResourceHandlers(ResourceHandlerRegistry registry) {
            String staticPathPattern;
            if (!this.resourceProperties.isAddMappings()) {
                logger.debug("Default resource handling disabled");
                return;
            }
            Integer cachePeriod = this.resourceProperties.getCachePeriod();
            if (!registry.hasMappingForPattern("/webjars/**")) {
                this.customizeResourceHandlerRegistration(registry.addResourceHandler(new String[]{"/webjars/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/"}).setCachePeriod(cachePeriod));
            }
            if (!registry.hasMappingForPattern(staticPathPattern = this.mvcProperties.getStaticPathPattern())) {
                this.customizeResourceHandlerRegistration(registry.addResourceHandler(new String[]{staticPathPattern}).addResourceLocations(this.resourceProperties.getStaticLocations()).setCachePeriod(cachePeriod));
            }
        }

        @Bean
        public WelcomePageHandlerMapping welcomePageHandlerMapping(ResourceProperties resourceProperties) {
            return new WelcomePageHandlerMapping(resourceProperties.getWelcomePage(), this.mvcProperties.getStaticPathPattern());
        }

        private void customizeResourceHandlerRegistration(ResourceHandlerRegistration registration) {
            if (this.resourceHandlerRegistrationCustomizer != null) {
                this.resourceHandlerRegistrationCustomizer.customize(registration);
            }
        }

        @Bean
        @ConditionalOnMissingBean(value={RequestContextListener.class, RequestContextFilter.class})
        public static RequestContextFilter requestContextFilter() {
            return new OrderedRequestContextFilter();
        }

        @Configuration
        @ConditionalOnProperty(value={"spring.mvc.favicon.enabled"}, matchIfMissing=true)
        public static class FaviconConfiguration {
            private final ResourceProperties resourceProperties;

            public FaviconConfiguration(ResourceProperties resourceProperties) {
                this.resourceProperties = resourceProperties;
            }

            @Bean
            public SimpleUrlHandlerMapping faviconHandlerMapping() {
                SimpleUrlHandlerMapping mapping = new SimpleUrlHandlerMapping();
                mapping.setOrder(-2147483647);
                mapping.setUrlMap(Collections.singletonMap("**/favicon.ico", this.faviconRequestHandler()));
                return mapping;
            }

            @Bean
            public ResourceHttpRequestHandler faviconRequestHandler() {
                ResourceHttpRequestHandler requestHandler = new ResourceHttpRequestHandler();
                requestHandler.setLocations(this.resourceProperties.getFaviconLocations());
                return requestHandler;
            }
        }
    }
}

