/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.context.embedded.tomcat;

import java.lang.reflect.Method;
import org.qubership.profiler.shaded.org.apache.catalina.Context;
import org.qubership.profiler.shaded.org.springframework.beans.BeanUtils;
import org.qubership.profiler.shaded.org.springframework.boot.web.servlet.ErrorPage;
import org.qubership.profiler.shaded.org.springframework.util.Assert;
import org.qubership.profiler.shaded.org.springframework.util.ClassUtils;
import org.qubership.profiler.shaded.org.springframework.util.ReflectionUtils;

class TomcatErrorPage {
    private static final String ERROR_PAGE_CLASS = "org.qubership.profiler.shaded.org.apache.tomcat.util.descriptor.web.ErrorPage";
    private static final String LEGACY_ERROR_PAGE_CLASS = "org.qubership.profiler.shaded.org.apache.catalina.deploy.ErrorPage";
    private final String location;
    private final String exceptionType;
    private final int errorCode;
    private final Object nativePage;

    TomcatErrorPage(ErrorPage errorPage) {
        this.location = errorPage.getPath();
        this.exceptionType = errorPage.getExceptionName();
        this.errorCode = errorPage.getStatusCode();
        this.nativePage = this.createNativePage();
    }

    private Object createNativePage() {
        try {
            if (ClassUtils.isPresent(ERROR_PAGE_CLASS, null)) {
                return BeanUtils.instantiate(ClassUtils.forName(ERROR_PAGE_CLASS, null));
            }
            if (ClassUtils.isPresent(LEGACY_ERROR_PAGE_CLASS, null)) {
                return BeanUtils.instantiate(ClassUtils.forName(LEGACY_ERROR_PAGE_CLASS, null));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
        return null;
    }

    public void addToContext(Context context) {
        Assert.state(this.nativePage != null, "Neither Tomcat 7 nor 8 detected so no native error page exists");
        if (ClassUtils.isPresent(ERROR_PAGE_CLASS, null)) {
            org.qubership.profiler.shaded.org.apache.tomcat.util.descriptor.web.ErrorPage errorPage = (org.qubership.profiler.shaded.org.apache.tomcat.util.descriptor.web.ErrorPage)this.nativePage;
            errorPage.setLocation(this.location);
            errorPage.setErrorCode(this.errorCode);
            errorPage.setExceptionType(this.exceptionType);
            context.addErrorPage(errorPage);
        } else {
            this.callMethod(this.nativePage, "setLocation", this.location, String.class);
            this.callMethod(this.nativePage, "setErrorCode", this.errorCode, Integer.TYPE);
            this.callMethod(this.nativePage, "setExceptionType", this.exceptionType, String.class);
            this.callMethod(context, "addErrorPage", this.nativePage, this.nativePage.getClass());
        }
    }

    private void callMethod(Object target, String name, Object value, Class<?> type) {
        Method method = ReflectionUtils.findMethod(target.getClass(), name, type);
        ReflectionUtils.invokeMethod(method, target, value);
    }
}

