/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.context.embedded.undertow;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.RequestHeaderAttribute;
import io.undertow.predicate.Predicate;
import io.undertow.predicate.Predicates;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.encoding.ContentEncodingProvider;
import io.undertow.server.handlers.encoding.ContentEncodingRepository;
import io.undertow.server.handlers.encoding.EncodingHandler;
import io.undertow.server.handlers.encoding.GzipEncodingProvider;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.lang.reflect.Field;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import org.qubership.profiler.shaded.org.apache.commons.logging.Log;
import org.qubership.profiler.shaded.org.apache.commons.logging.LogFactory;
import org.qubership.profiler.shaded.org.springframework.boot.context.embedded.Compression;
import org.qubership.profiler.shaded.org.springframework.boot.context.embedded.EmbeddedServletContainer;
import org.qubership.profiler.shaded.org.springframework.boot.context.embedded.EmbeddedServletContainerException;
import org.qubership.profiler.shaded.org.springframework.boot.context.embedded.PortInUseException;
import org.qubership.profiler.shaded.org.springframework.util.MimeType;
import org.qubership.profiler.shaded.org.springframework.util.MimeTypeUtils;
import org.qubership.profiler.shaded.org.springframework.util.ReflectionUtils;
import org.qubership.profiler.shaded.org.springframework.util.StringUtils;
import org.xnio.channels.BoundChannel;

public class UndertowEmbeddedServletContainer
implements EmbeddedServletContainer {
    private static final Log logger = LogFactory.getLog(UndertowEmbeddedServletContainer.class);
    private final Object monitor = new Object();
    private final Undertow.Builder builder;
    private final DeploymentManager manager;
    private final String contextPath;
    private final boolean useForwardHeaders;
    private final boolean autoStart;
    private final Compression compression;
    private final String serverHeader;
    private Undertow undertow;
    private volatile boolean started = false;

    public UndertowEmbeddedServletContainer(Undertow.Builder builder, DeploymentManager manager, String contextPath, boolean autoStart, Compression compression) {
        this(builder, manager, contextPath, false, autoStart, compression);
    }

    public UndertowEmbeddedServletContainer(Undertow.Builder builder, DeploymentManager manager, String contextPath, boolean useForwardHeaders, boolean autoStart, Compression compression) {
        this(builder, manager, contextPath, useForwardHeaders, autoStart, compression, null);
    }

    public UndertowEmbeddedServletContainer(Undertow.Builder builder, DeploymentManager manager, String contextPath, boolean useForwardHeaders, boolean autoStart, Compression compression, String serverHeader) {
        this.builder = builder;
        this.manager = manager;
        this.contextPath = contextPath;
        this.useForwardHeaders = useForwardHeaders;
        this.autoStart = autoStart;
        this.compression = compression;
        this.serverHeader = serverHeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws EmbeddedServletContainerException {
        Object object = this.monitor;
        synchronized (object) {
            if (this.started) {
                return;
            }
            try {
                if (!this.autoStart) {
                    return;
                }
                if (this.undertow == null) {
                    this.undertow = this.createUndertowServer();
                }
                this.undertow.start();
                this.started = true;
                logger.info("Undertow started on port(s) " + this.getPortsDescription());
            }
            catch (Exception ex) {
                try {
                    if (this.findBindException(ex) != null) {
                        List<Port> failedPorts = this.getConfiguredPorts();
                        List<Port> actualPorts = this.getActualPorts();
                        failedPorts.removeAll(actualPorts);
                        if (failedPorts.size() == 1) {
                            throw new PortInUseException(failedPorts.iterator().next().getNumber());
                        }
                    }
                    throw new EmbeddedServletContainerException("Unable to start embedded Undertow", ex);
                }
                catch (Throwable throwable) {
                    this.stopSilently();
                    throw throwable;
                }
            }
        }
    }

    private void stopSilently() {
        try {
            if (this.manager != null) {
                this.manager.stop();
            }
            if (this.undertow != null) {
                this.undertow.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private BindException findBindException(Exception ex) {
        for (Throwable candidate = ex; candidate != null; candidate = candidate.getCause()) {
            if (!(candidate instanceof BindException)) continue;
            return (BindException)candidate;
        }
        return null;
    }

    private Undertow createUndertowServer() throws ServletException {
        HttpHandler httpHandler = this.manager.start();
        httpHandler = this.getContextHandler(httpHandler);
        if (this.useForwardHeaders) {
            httpHandler = Handlers.proxyPeerAddress((HttpHandler)httpHandler);
        }
        if (StringUtils.hasText(this.serverHeader)) {
            httpHandler = Handlers.header((HttpHandler)httpHandler, (String)"Server", (String)this.serverHeader);
        }
        this.builder.setHandler(httpHandler);
        return this.builder.build();
    }

    private HttpHandler getContextHandler(HttpHandler httpHandler) {
        HttpHandler contextHandler = this.configurationCompressionIfNecessary(httpHandler);
        if (StringUtils.isEmpty(this.contextPath)) {
            return contextHandler;
        }
        return Handlers.path().addPrefixPath(this.contextPath, contextHandler);
    }

    private HttpHandler configurationCompressionIfNecessary(HttpHandler httpHandler) {
        if (this.compression == null || !this.compression.getEnabled()) {
            return httpHandler;
        }
        ContentEncodingRepository repository = new ContentEncodingRepository();
        repository.addEncodingHandler("gzip", (ContentEncodingProvider)new GzipEncodingProvider(), 50, Predicates.and((Predicate[])this.getCompressionPredicates(this.compression)));
        return new EncodingHandler(repository).setNext(httpHandler);
    }

    private Predicate[] getCompressionPredicates(Compression compression) {
        ArrayList<Object> predicates = new ArrayList<Object>();
        predicates.add(new MaxSizePredicate(compression.getMinResponseSize()));
        predicates.add(new CompressibleMimeTypePredicate(compression.getMimeTypes()));
        if (compression.getExcludedUserAgents() != null) {
            for (String agent : compression.getExcludedUserAgents()) {
                RequestHeaderAttribute agentHeader = new RequestHeaderAttribute(new HttpString("User-Agent"));
                predicates.add(Predicates.not((Predicate)Predicates.regex((ExchangeAttribute)agentHeader, (String)agent)));
            }
        }
        return predicates.toArray(new Predicate[predicates.size()]);
    }

    private String getPortsDescription() {
        List<Port> ports = this.getActualPorts();
        if (!ports.isEmpty()) {
            return StringUtils.collectionToDelimitedString(ports, " ");
        }
        return "unknown";
    }

    private List<Port> getActualPorts() {
        ArrayList<Port> ports = new ArrayList<Port>();
        try {
            if (!this.autoStart) {
                ports.add(new Port(-1, "unknown"));
            } else {
                for (BoundChannel channel : this.extractChannels()) {
                    ports.add(this.getPortFromChannel(channel));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ports;
    }

    private List<BoundChannel> extractChannels() {
        Field channelsField = ReflectionUtils.findField(Undertow.class, "channels");
        ReflectionUtils.makeAccessible(channelsField);
        return (List)ReflectionUtils.getField(channelsField, this.undertow);
    }

    private Port getPortFromChannel(BoundChannel channel) {
        SocketAddress socketAddress = channel.getLocalAddress();
        if (socketAddress instanceof InetSocketAddress) {
            Field field = ReflectionUtils.findField(channel.getClass(), "ssl");
            String protocol = field != null ? "https" : "http";
            return new Port(((InetSocketAddress)socketAddress).getPort(), protocol);
        }
        return null;
    }

    private List<Port> getConfiguredPorts() {
        ArrayList<Port> ports = new ArrayList<Port>();
        for (Object listener : this.extractListeners()) {
            try {
                ports.add(this.getPortFromListener(listener));
            }
            catch (Exception exception) {}
        }
        return ports;
    }

    private List<Object> extractListeners() {
        Field listenersField = ReflectionUtils.findField(Undertow.class, "listeners");
        ReflectionUtils.makeAccessible(listenersField);
        return (List)ReflectionUtils.getField(listenersField, this.undertow);
    }

    private Port getPortFromListener(Object listener) {
        Field typeField = ReflectionUtils.findField(listener.getClass(), "type");
        ReflectionUtils.makeAccessible(typeField);
        String protocol = ReflectionUtils.getField(typeField, listener).toString();
        Field portField = ReflectionUtils.findField(listener.getClass(), "port");
        ReflectionUtils.makeAccessible(portField);
        int port = (Integer)ReflectionUtils.getField(portField, listener);
        return new Port(port, protocol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws EmbeddedServletContainerException {
        Object object = this.monitor;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            this.started = false;
            try {
                this.manager.stop();
                this.manager.undeploy();
                this.undertow.stop();
            }
            catch (Exception ex) {
                throw new EmbeddedServletContainerException("Unable to stop undertow", ex);
            }
        }
    }

    @Override
    public int getPort() {
        List<Port> ports = this.getActualPorts();
        if (ports.isEmpty()) {
            return 0;
        }
        return ports.get(0).getNumber();
    }

    private static class MaxSizePredicate
    implements Predicate {
        private final Predicate maxContentSize;

        MaxSizePredicate(int size) {
            this.maxContentSize = Predicates.maxContentSize((long)size);
        }

        public boolean resolve(HttpServerExchange value) {
            if (value.getResponseHeaders().contains(Headers.CONTENT_LENGTH)) {
                return this.maxContentSize.resolve(value);
            }
            return true;
        }
    }

    private static class CompressibleMimeTypePredicate
    implements Predicate {
        private final List<MimeType> mimeTypes;

        CompressibleMimeTypePredicate(String[] mimeTypes) {
            this.mimeTypes = new ArrayList<MimeType>(mimeTypes.length);
            for (String mimeTypeString : mimeTypes) {
                this.mimeTypes.add(MimeTypeUtils.parseMimeType(mimeTypeString));
            }
        }

        public boolean resolve(HttpServerExchange value) {
            String contentType = value.getResponseHeaders().getFirst("Content-Type");
            if (contentType != null) {
                for (MimeType mimeType : this.mimeTypes) {
                    if (!mimeType.isCompatibleWith(MimeTypeUtils.parseMimeType(contentType))) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private static final class Port {
        private final int number;
        private final String protocol;

        private Port(int number, String protocol) {
            this.number = number;
            this.protocol = protocol;
        }

        public int getNumber() {
            return this.number;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Port other = (Port)obj;
            return this.number == other.number;
        }

        public int hashCode() {
            return this.number;
        }

        public String toString() {
            return this.number + " (" + this.protocol + ")";
        }
    }
}

