/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.diagnostics.analyzer;

import org.qubership.profiler.shaded.org.springframework.boot.diagnostics.AbstractFailureAnalyzer;
import org.qubership.profiler.shaded.org.springframework.boot.diagnostics.FailureAnalysis;
import org.qubership.profiler.shaded.org.springframework.util.CollectionUtils;
import org.qubership.profiler.shaded.org.springframework.validation.BindException;
import org.qubership.profiler.shaded.org.springframework.validation.FieldError;
import org.qubership.profiler.shaded.org.springframework.validation.ObjectError;

class BindFailureAnalyzer
extends AbstractFailureAnalyzer<BindException> {
    BindFailureAnalyzer() {
    }

    @Override
    protected FailureAnalysis analyze(Throwable rootFailure, BindException cause) {
        if (CollectionUtils.isEmpty(cause.getAllErrors())) {
            return null;
        }
        StringBuilder description = new StringBuilder(String.format("Binding to target %s failed:%n", cause.getTarget()));
        for (ObjectError error : cause.getAllErrors()) {
            if (error instanceof FieldError) {
                FieldError fieldError = (FieldError)error;
                description.append(String.format("%n    Property: %s", cause.getObjectName() + "." + fieldError.getField()));
                description.append(String.format("%n    Value: %s", fieldError.getRejectedValue()));
            }
            description.append(String.format("%n    Reason: %s%n", error.getDefaultMessage()));
        }
        return new FailureAnalysis(description.toString(), "Update your application's configuration", cause);
    }
}

