/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.jackson;

import java.lang.reflect.Modifier;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.qubership.profiler.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import org.qubership.profiler.shaded.com.fasterxml.jackson.databind.JsonSerializer;
import org.qubership.profiler.shaded.com.fasterxml.jackson.databind.module.SimpleModule;
import org.qubership.profiler.shaded.org.springframework.beans.BeansException;
import org.qubership.profiler.shaded.org.springframework.beans.factory.BeanFactory;
import org.qubership.profiler.shaded.org.springframework.beans.factory.BeanFactoryAware;
import org.qubership.profiler.shaded.org.springframework.beans.factory.HierarchicalBeanFactory;
import org.qubership.profiler.shaded.org.springframework.beans.factory.ListableBeanFactory;
import org.qubership.profiler.shaded.org.springframework.boot.jackson.JsonComponent;
import org.qubership.profiler.shaded.org.springframework.core.ResolvableType;

public class JsonComponentModule
extends SimpleModule
implements BeanFactoryAware {
    private BeanFactory beanFactory;

    @Override
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    @PostConstruct
    public void registerJsonComponents() {
        BeanFactory beanFactory = this.beanFactory;
        while (beanFactory != null) {
            if (beanFactory instanceof ListableBeanFactory) {
                this.addJsonBeans((ListableBeanFactory)beanFactory);
            }
            beanFactory = beanFactory instanceof HierarchicalBeanFactory ? ((HierarchicalBeanFactory)beanFactory).getParentBeanFactory() : null;
        }
    }

    private void addJsonBeans(ListableBeanFactory beanFactory) {
        Map<String, Object> beans = beanFactory.getBeansWithAnnotation(JsonComponent.class);
        for (Object bean : beans.values()) {
            this.addJsonBean(bean);
        }
    }

    private void addJsonBean(Object bean) {
        if (bean instanceof JsonSerializer) {
            this.addSerializerWithDeducedType((JsonSerializer)bean);
        }
        if (bean instanceof JsonDeserializer) {
            this.addDeserializerWithDeducedType((JsonDeserializer)bean);
        }
        for (Class<?> innerClass : bean.getClass().getDeclaredClasses()) {
            if (Modifier.isAbstract(innerClass.getModifiers()) || !JsonSerializer.class.isAssignableFrom(innerClass) && !JsonDeserializer.class.isAssignableFrom(innerClass)) continue;
            try {
                this.addJsonBean(innerClass.newInstance());
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    private <T> void addSerializerWithDeducedType(JsonSerializer<T> serializer) {
        ResolvableType type = ResolvableType.forClass(JsonSerializer.class, serializer.getClass());
        this.addSerializer(type.resolveGeneric(new int[0]), serializer);
    }

    private <T> void addDeserializerWithDeducedType(JsonDeserializer<T> deserializer) {
        ResolvableType type = ResolvableType.forClass(JsonDeserializer.class, deserializer.getClass());
        this.addDeserializer(type.resolveGeneric(new int[0]), deserializer);
    }
}

