/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.liquibase;

import liquibase.logging.LogFactory;
import liquibase.servicelocator.CustomResolverServiceLocator;
import liquibase.servicelocator.PackageScanClassResolver;
import liquibase.servicelocator.ServiceLocator;
import org.qubership.profiler.shaded.org.apache.commons.logging.Log;
import org.qubership.profiler.shaded.org.springframework.boot.context.event.ApplicationStartingEvent;
import org.qubership.profiler.shaded.org.springframework.boot.liquibase.CommonsLoggingLiquibaseLogger;
import org.qubership.profiler.shaded.org.springframework.boot.liquibase.SpringPackageScanClassResolver;
import org.qubership.profiler.shaded.org.springframework.context.ApplicationListener;
import org.qubership.profiler.shaded.org.springframework.util.ClassUtils;

public class LiquibaseServiceLocatorApplicationListener
implements ApplicationListener<ApplicationStartingEvent> {
    private static final Log logger = org.qubership.profiler.shaded.org.apache.commons.logging.LogFactory.getLog(LiquibaseServiceLocatorApplicationListener.class);

    @Override
    public void onApplicationEvent(ApplicationStartingEvent event) {
        if (ClassUtils.isPresent("liquibase.servicelocator.CustomResolverServiceLocator", event.getSpringApplication().getClassLoader())) {
            new LiquibasePresent().replaceServiceLocator();
        }
    }

    private static class LiquibasePresent {
        private LiquibasePresent() {
        }

        public void replaceServiceLocator() {
            CustomResolverServiceLocator customResolverServiceLocator = new CustomResolverServiceLocator((PackageScanClassResolver)new SpringPackageScanClassResolver(logger));
            customResolverServiceLocator.addPackageToScan(CommonsLoggingLiquibaseLogger.class.getPackage().getName());
            ServiceLocator.setInstance((ServiceLocator)customResolverServiceLocator);
            LogFactory.reset();
        }
    }
}

