/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.logging;

import org.qubership.profiler.shaded.org.springframework.boot.ApplicationPid;
import org.qubership.profiler.shaded.org.springframework.boot.bind.RelaxedPropertyResolver;
import org.qubership.profiler.shaded.org.springframework.boot.logging.LogFile;
import org.qubership.profiler.shaded.org.springframework.core.env.Environment;

class LoggingSystemProperties {
    static final String PID_KEY = "PID";
    static final String EXCEPTION_CONVERSION_WORD = "LOG_EXCEPTION_CONVERSION_WORD";
    static final String CONSOLE_LOG_PATTERN = "CONSOLE_LOG_PATTERN";
    static final String FILE_LOG_PATTERN = "FILE_LOG_PATTERN";
    static final String LOG_LEVEL_PATTERN = "LOG_LEVEL_PATTERN";
    private final Environment environment;

    LoggingSystemProperties(Environment environment) {
        this.environment = environment;
    }

    public void apply() {
        this.apply(null);
    }

    public void apply(LogFile logFile) {
        RelaxedPropertyResolver propertyResolver = RelaxedPropertyResolver.ignoringUnresolvableNestedPlaceholders(this.environment, "logging.");
        this.setSystemProperty(propertyResolver, EXCEPTION_CONVERSION_WORD, "exception-conversion-word");
        this.setSystemProperty(PID_KEY, new ApplicationPid().toString());
        this.setSystemProperty(propertyResolver, CONSOLE_LOG_PATTERN, "pattern.console");
        this.setSystemProperty(propertyResolver, FILE_LOG_PATTERN, "pattern.file");
        this.setSystemProperty(propertyResolver, LOG_LEVEL_PATTERN, "pattern.level");
        if (logFile != null) {
            logFile.applyToSystemProperties();
        }
    }

    private void setSystemProperty(RelaxedPropertyResolver propertyResolver, String systemPropertyName, String propertyName) {
        this.setSystemProperty(systemPropertyName, propertyResolver.getProperty(propertyName));
    }

    private void setSystemProperty(String name, String value) {
        if (System.getProperty(name) == null && value != null) {
            System.setProperty(name, value);
        }
    }
}

