/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.logging.logback;

import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.qubership.profiler.shaded.ch.qos.logback.classic.Level;
import org.qubership.profiler.shaded.ch.qos.logback.classic.Logger;
import org.qubership.profiler.shaded.ch.qos.logback.classic.LoggerContext;
import org.qubership.profiler.shaded.ch.qos.logback.classic.jul.LevelChangePropagator;
import org.qubership.profiler.shaded.ch.qos.logback.classic.turbo.TurboFilter;
import org.qubership.profiler.shaded.ch.qos.logback.classic.util.ContextInitializer;
import org.qubership.profiler.shaded.ch.qos.logback.core.joran.spi.JoranException;
import org.qubership.profiler.shaded.ch.qos.logback.core.spi.FilterReply;
import org.qubership.profiler.shaded.ch.qos.logback.core.status.Status;
import org.qubership.profiler.shaded.org.slf4j.ILoggerFactory;
import org.qubership.profiler.shaded.org.slf4j.Marker;
import org.qubership.profiler.shaded.org.slf4j.impl.StaticLoggerBinder;
import org.qubership.profiler.shaded.org.springframework.boot.logging.AbstractLoggingSystem;
import org.qubership.profiler.shaded.org.springframework.boot.logging.LogFile;
import org.qubership.profiler.shaded.org.springframework.boot.logging.LogLevel;
import org.qubership.profiler.shaded.org.springframework.boot.logging.LoggerConfiguration;
import org.qubership.profiler.shaded.org.springframework.boot.logging.LoggingInitializationContext;
import org.qubership.profiler.shaded.org.springframework.boot.logging.LoggingSystem;
import org.qubership.profiler.shaded.org.springframework.boot.logging.Slf4JLoggingSystem;
import org.qubership.profiler.shaded.org.springframework.boot.logging.logback.DefaultLogbackConfiguration;
import org.qubership.profiler.shaded.org.springframework.boot.logging.logback.LogbackConfigurator;
import org.qubership.profiler.shaded.org.springframework.boot.logging.logback.SpringBootJoranConfigurator;
import org.qubership.profiler.shaded.org.springframework.util.Assert;
import org.qubership.profiler.shaded.org.springframework.util.ResourceUtils;
import org.qubership.profiler.shaded.org.springframework.util.StringUtils;

public class LogbackLoggingSystem
extends Slf4JLoggingSystem {
    private static final String CONFIGURATION_FILE_PROPERTY = "logback.configurationFile";
    private static final AbstractLoggingSystem.LogLevels<Level> LEVELS = new AbstractLoggingSystem.LogLevels();
    private static final TurboFilter FILTER;

    public LogbackLoggingSystem(ClassLoader classLoader) {
        super(classLoader);
    }

    @Override
    protected String[] getStandardConfigLocations() {
        return new String[]{"logback-test.groovy", "logback-test.xml", "logback.groovy", "logback.xml"};
    }

    @Override
    public void beforeInitialize() {
        LoggerContext loggerContext = this.getLoggerContext();
        if (this.isAlreadyInitialized(loggerContext)) {
            return;
        }
        super.beforeInitialize();
        loggerContext.getTurboFilterList().add(FILTER);
        this.configureJBossLoggingToUseSlf4j();
    }

    @Override
    public void initialize(LoggingInitializationContext initializationContext, String configLocation, LogFile logFile) {
        LoggerContext loggerContext = this.getLoggerContext();
        if (this.isAlreadyInitialized(loggerContext)) {
            return;
        }
        super.initialize(initializationContext, configLocation, logFile);
        loggerContext.getTurboFilterList().remove(FILTER);
        this.markAsInitialized(loggerContext);
        if (StringUtils.hasText(System.getProperty(CONFIGURATION_FILE_PROPERTY))) {
            this.getLogger(LogbackLoggingSystem.class.getName()).warn("Ignoring 'logback.configurationFile' system property. Please use 'logging.config' instead.");
        }
    }

    @Override
    protected void loadDefaults(LoggingInitializationContext initializationContext, LogFile logFile) {
        LoggerContext context = this.getLoggerContext();
        this.stopAndReset(context);
        LogbackConfigurator configurator = new LogbackConfigurator(context);
        context.putProperty("LOG_LEVEL_PATTERN", initializationContext.getEnvironment().resolvePlaceholders("${logging.pattern.level:${LOG_LEVEL_PATTERN:%5p}}"));
        new DefaultLogbackConfiguration(initializationContext, logFile).apply(configurator);
        context.setPackagingDataEnabled(true);
    }

    @Override
    protected void loadConfiguration(LoggingInitializationContext initializationContext, String location, LogFile logFile) {
        super.loadConfiguration(initializationContext, location, logFile);
        LoggerContext loggerContext = this.getLoggerContext();
        this.stopAndReset(loggerContext);
        try {
            this.configureByResourceUrl(initializationContext, loggerContext, ResourceUtils.getURL(location));
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not initialize Logback logging from " + location, ex);
        }
        List<Status> statuses = loggerContext.getStatusManager().getCopyOfStatusList();
        StringBuilder errors = new StringBuilder();
        for (Status status : statuses) {
            if (status.getLevel() != 2) continue;
            errors.append(errors.length() > 0 ? String.format("%n", new Object[0]) : "");
            errors.append(status.toString());
        }
        if (errors.length() > 0) {
            throw new IllegalStateException(String.format("Logback configuration error detected: %n%s", errors));
        }
    }

    private void configureByResourceUrl(LoggingInitializationContext initializationContext, LoggerContext loggerContext, URL url) throws JoranException {
        if (url.toString().endsWith("xml")) {
            SpringBootJoranConfigurator configurator = new SpringBootJoranConfigurator(initializationContext);
            configurator.setContext(loggerContext);
            configurator.doConfigure(url);
        } else {
            new ContextInitializer(loggerContext).configureByResource(url);
        }
    }

    private void stopAndReset(LoggerContext loggerContext) {
        loggerContext.stop();
        loggerContext.reset();
        if (this.isBridgeHandlerAvailable()) {
            this.addLevelChangePropagator(loggerContext);
        }
    }

    private void addLevelChangePropagator(LoggerContext loggerContext) {
        LevelChangePropagator levelChangePropagator = new LevelChangePropagator();
        levelChangePropagator.setResetJUL(true);
        levelChangePropagator.setContext(loggerContext);
        loggerContext.addListener(levelChangePropagator);
    }

    @Override
    public void cleanUp() {
        LoggerContext context = this.getLoggerContext();
        this.markAsUninitialized(context);
        super.cleanUp();
        context.getStatusManager().clear();
        context.getTurboFilterList().remove(FILTER);
    }

    @Override
    protected void reinitialize(LoggingInitializationContext initializationContext) {
        this.getLoggerContext().reset();
        this.getLoggerContext().getStatusManager().clear();
        this.loadConfiguration(initializationContext, this.getSelfInitializationConfig(), null);
    }

    private void configureJBossLoggingToUseSlf4j() {
        System.setProperty("org.jboss.logging.provider", "slf4j");
    }

    @Override
    public List<LoggerConfiguration> getLoggerConfigurations() {
        ArrayList<LoggerConfiguration> result = new ArrayList<LoggerConfiguration>();
        for (Logger logger : this.getLoggerContext().getLoggerList()) {
            result.add(this.getLoggerConfiguration(logger));
        }
        Collections.sort(result, CONFIGURATION_COMPARATOR);
        return result;
    }

    @Override
    public LoggerConfiguration getLoggerConfiguration(String loggerName) {
        return this.getLoggerConfiguration(this.getLogger(loggerName));
    }

    private LoggerConfiguration getLoggerConfiguration(Logger logger) {
        if (logger == null) {
            return null;
        }
        LogLevel level = LEVELS.convertNativeToSystem(logger.getLevel());
        LogLevel effectiveLevel = LEVELS.convertNativeToSystem(logger.getEffectiveLevel());
        String name = logger.getName();
        if (!StringUtils.hasLength(name) || "ROOT".equals(name)) {
            name = "ROOT";
        }
        return new LoggerConfiguration(name, level, effectiveLevel);
    }

    @Override
    public Set<LogLevel> getSupportedLogLevels() {
        return LEVELS.getSupported();
    }

    @Override
    public void setLogLevel(String loggerName, LogLevel level) {
        Logger logger = this.getLogger(loggerName);
        if (logger != null) {
            logger.setLevel(LEVELS.convertSystemToNative(level));
        }
    }

    @Override
    public Runnable getShutdownHandler() {
        return new ShutdownHandler();
    }

    private Logger getLogger(String name) {
        LoggerContext factory = this.getLoggerContext();
        if (StringUtils.isEmpty(name) || "ROOT".equals(name)) {
            name = "ROOT";
        }
        return factory.getLogger(name);
    }

    private LoggerContext getLoggerContext() {
        ILoggerFactory factory = StaticLoggerBinder.getSingleton().getLoggerFactory();
        Assert.isInstanceOf(LoggerContext.class, factory, String.format("LoggerFactory is not a Logback LoggerContext but Logback is on the classpath. Either remove Logback or the competing implementation (%s loaded from %s). If you are using WebLogic you will need to add 'org.slf4j' to prefer-application-packages in WEB-INF/weblogic.xml", factory.getClass(), this.getLocation(factory)));
        return (LoggerContext)factory;
    }

    private Object getLocation(ILoggerFactory factory) {
        try {
            ProtectionDomain protectionDomain = factory.getClass().getProtectionDomain();
            CodeSource codeSource = protectionDomain.getCodeSource();
            if (codeSource != null) {
                return codeSource.getLocation();
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return "unknown location";
    }

    private boolean isAlreadyInitialized(LoggerContext loggerContext) {
        return loggerContext.getObject(LoggingSystem.class.getName()) != null;
    }

    private void markAsInitialized(LoggerContext loggerContext) {
        loggerContext.putObject(LoggingSystem.class.getName(), new Object());
    }

    private void markAsUninitialized(LoggerContext loggerContext) {
        loggerContext.removeObject(LoggingSystem.class.getName());
    }

    static {
        LEVELS.map(LogLevel.TRACE, Level.TRACE);
        LEVELS.map(LogLevel.TRACE, Level.ALL);
        LEVELS.map(LogLevel.DEBUG, Level.DEBUG);
        LEVELS.map(LogLevel.INFO, Level.INFO);
        LEVELS.map(LogLevel.WARN, Level.WARN);
        LEVELS.map(LogLevel.ERROR, Level.ERROR);
        LEVELS.map(LogLevel.FATAL, Level.ERROR);
        LEVELS.map(LogLevel.OFF, Level.OFF);
        FILTER = new TurboFilter(){

            @Override
            public FilterReply decide(Marker marker, Logger logger, Level level, String format, Object[] params, Throwable t) {
                return FilterReply.DENY;
            }
        };
    }

    private final class ShutdownHandler
    implements Runnable {
        private ShutdownHandler() {
        }

        @Override
        public void run() {
            LogbackLoggingSystem.this.getLoggerContext().stop();
        }
    }
}

