/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.web.servlet;

import java.util.Locale;
import javax.servlet.MultipartConfigElement;
import org.qubership.profiler.shaded.org.springframework.util.Assert;

public class MultipartConfigFactory {
    private String location;
    private long maxFileSize = -1L;
    private long maxRequestSize = -1L;
    private int fileSizeThreshold = 0;

    public void setLocation(String location) {
        this.location = location;
    }

    public void setMaxFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public void setMaxFileSize(String maxFileSize) {
        this.maxFileSize = this.parseSize(maxFileSize);
    }

    public void setMaxRequestSize(long maxRequestSize) {
        this.maxRequestSize = maxRequestSize;
    }

    public void setMaxRequestSize(String maxRequestSize) {
        this.maxRequestSize = this.parseSize(maxRequestSize);
    }

    public void setFileSizeThreshold(int fileSizeThreshold) {
        this.fileSizeThreshold = fileSizeThreshold;
    }

    public void setFileSizeThreshold(String fileSizeThreshold) {
        this.fileSizeThreshold = (int)this.parseSize(fileSizeThreshold);
    }

    private long parseSize(String size) {
        Assert.hasLength(size, "Size must not be empty");
        size = size.toUpperCase(Locale.ENGLISH);
        if (size.endsWith("KB")) {
            return Long.valueOf(size.substring(0, size.length() - 2)) * 1024L;
        }
        if (size.endsWith("MB")) {
            return Long.valueOf(size.substring(0, size.length() - 2)) * 1024L * 1024L;
        }
        return Long.valueOf(size);
    }

    public MultipartConfigElement createMultipartConfig() {
        return new MultipartConfigElement(this.location, this.maxFileSize, this.maxRequestSize, this.fileSizeThreshold);
    }
}

