/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.web.servlet;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.qubership.profiler.shaded.org.springframework.beans.factory.config.BeanDefinition;
import org.qubership.profiler.shaded.org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.qubership.profiler.shaded.org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.qubership.profiler.shaded.org.springframework.beans.factory.support.GenericBeanDefinition;
import org.qubership.profiler.shaded.org.springframework.boot.web.servlet.ServletComponentRegisteringPostProcessor;
import org.qubership.profiler.shaded.org.springframework.boot.web.servlet.ServletComponentScan;
import org.qubership.profiler.shaded.org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.qubership.profiler.shaded.org.springframework.core.annotation.AnnotationAttributes;
import org.qubership.profiler.shaded.org.springframework.core.type.AnnotationMetadata;
import org.qubership.profiler.shaded.org.springframework.util.ClassUtils;

class ServletComponentScanRegistrar
implements ImportBeanDefinitionRegistrar {
    private static final String BEAN_NAME = "servletComponentRegisteringPostProcessor";

    ServletComponentScanRegistrar() {
    }

    @Override
    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        Set<String> packagesToScan = this.getPackagesToScan(importingClassMetadata);
        if (registry.containsBeanDefinition(BEAN_NAME)) {
            this.updatePostProcessor(registry, packagesToScan);
        } else {
            this.addPostProcessor(registry, packagesToScan);
        }
    }

    private void updatePostProcessor(BeanDefinitionRegistry registry, Set<String> packagesToScan) {
        BeanDefinition definition = registry.getBeanDefinition(BEAN_NAME);
        ConstructorArgumentValues.ValueHolder constructorArguments = definition.getConstructorArgumentValues().getGenericArgumentValue(Set.class);
        Set mergedPackages = (Set)constructorArguments.getValue();
        mergedPackages.addAll(packagesToScan);
        constructorArguments.setValue(mergedPackages);
    }

    private void addPostProcessor(BeanDefinitionRegistry registry, Set<String> packagesToScan) {
        GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
        beanDefinition.setBeanClass(ServletComponentRegisteringPostProcessor.class);
        beanDefinition.getConstructorArgumentValues().addGenericArgumentValue(packagesToScan);
        beanDefinition.setRole(2);
        registry.registerBeanDefinition(BEAN_NAME, beanDefinition);
    }

    private Set<String> getPackagesToScan(AnnotationMetadata metadata) {
        AnnotationAttributes attributes = AnnotationAttributes.fromMap(metadata.getAnnotationAttributes(ServletComponentScan.class.getName()));
        String[] basePackages = attributes.getStringArray("basePackages");
        Class<?>[] basePackageClasses = attributes.getClassArray("basePackageClasses");
        LinkedHashSet<String> packagesToScan = new LinkedHashSet<String>();
        packagesToScan.addAll(Arrays.asList(basePackages));
        for (Class<?> basePackageClass : basePackageClasses) {
            packagesToScan.add(ClassUtils.getPackageName(basePackageClass));
        }
        if (packagesToScan.isEmpty()) {
            packagesToScan.add(ClassUtils.getPackageName(metadata.getClassName()));
        }
        return packagesToScan;
    }
}

