/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.core.type.classreading;

import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.qubership.profiler.shaded.org.springframework.core.annotation.AnnotationAttributes;
import org.qubership.profiler.shaded.org.springframework.core.annotation.AnnotationUtils;
import org.qubership.profiler.shaded.org.springframework.core.type.classreading.RecursiveAnnotationAttributesVisitor;
import org.qubership.profiler.shaded.org.springframework.util.MultiValueMap;
import org.qubership.profiler.shaded.org.springframework.util.ObjectUtils;

final class AnnotationAttributesReadingVisitor
extends RecursiveAnnotationAttributesVisitor {
    private final MultiValueMap<String, AnnotationAttributes> attributesMap;
    private final Map<String, Set<String>> metaAnnotationMap;

    public AnnotationAttributesReadingVisitor(String annotationType, MultiValueMap<String, AnnotationAttributes> attributesMap, Map<String, Set<String>> metaAnnotationMap, ClassLoader classLoader) {
        super(annotationType, new AnnotationAttributes(annotationType, classLoader), classLoader);
        this.attributesMap = attributesMap;
        this.metaAnnotationMap = metaAnnotationMap;
    }

    @Override
    public void visitEnd() {
        super.visitEnd();
        Class<? extends Annotation> annotationClass = this.attributes.annotationType();
        if (annotationClass != null) {
            List attributeList = (List)this.attributesMap.get(this.annotationType);
            if (attributeList == null) {
                this.attributesMap.add(this.annotationType, this.attributes);
            } else {
                attributeList.add(0, this.attributes);
            }
            if (!AnnotationUtils.isInJavaLangAnnotationPackage(annotationClass.getName())) {
                LinkedHashSet<Annotation> visited = new LinkedHashSet<Annotation>();
                Object[] metaAnnotations = AnnotationUtils.getAnnotations(annotationClass);
                if (!ObjectUtils.isEmpty(metaAnnotations)) {
                    for (Object metaAnnotation : metaAnnotations) {
                        this.recursivelyCollectMetaAnnotations(visited, (Annotation)metaAnnotation);
                    }
                }
                if (this.metaAnnotationMap != null) {
                    LinkedHashSet<String> metaAnnotationTypeNames = new LinkedHashSet<String>(visited.size());
                    for (Annotation ann : visited) {
                        metaAnnotationTypeNames.add(ann.annotationType().getName());
                    }
                    this.metaAnnotationMap.put(annotationClass.getName(), metaAnnotationTypeNames);
                }
            }
        }
    }

    private void recursivelyCollectMetaAnnotations(Set<Annotation> visited, Annotation annotation) {
        block5: {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            String annotationName = annotationType.getName();
            if (!AnnotationUtils.isInJavaLangAnnotationPackage(annotationName) && visited.add(annotation)) {
                try {
                    if (Modifier.isPublic(annotationType.getModifiers())) {
                        this.attributesMap.add(annotationName, AnnotationUtils.getAnnotationAttributes(annotation, false, true));
                    }
                    for (Annotation metaMetaAnnotation : annotationType.getAnnotations()) {
                        this.recursivelyCollectMetaAnnotations(visited, metaMetaAnnotation);
                    }
                }
                catch (Throwable ex) {
                    if (!this.logger.isDebugEnabled()) break block5;
                    this.logger.debug("Failed to introspect meta-annotations on " + annotation + ": " + ex);
                }
            }
        }
    }
}

