/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.expression.spel.ast;

import org.qubership.profiler.shaded.org.springframework.asm.Label;
import org.qubership.profiler.shaded.org.springframework.asm.MethodVisitor;
import org.qubership.profiler.shaded.org.springframework.expression.EvaluationException;
import org.qubership.profiler.shaded.org.springframework.expression.TypedValue;
import org.qubership.profiler.shaded.org.springframework.expression.spel.CodeFlow;
import org.qubership.profiler.shaded.org.springframework.expression.spel.ExpressionState;
import org.qubership.profiler.shaded.org.springframework.expression.spel.SpelEvaluationException;
import org.qubership.profiler.shaded.org.springframework.expression.spel.SpelMessage;
import org.qubership.profiler.shaded.org.springframework.expression.spel.ast.SpelNodeImpl;

public class Ternary
extends SpelNodeImpl {
    public Ternary(int pos, SpelNodeImpl ... args) {
        super(pos, args);
    }

    @Override
    public TypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        Boolean value = this.children[0].getValue(state, Boolean.class);
        if (value == null) {
            throw new SpelEvaluationException(this.getChild(0).getStartPosition(), SpelMessage.TYPE_CONVERSION_ERROR, "null", "boolean");
        }
        TypedValue result = this.children[value != false ? 1 : 2].getValueInternal(state);
        this.computeExitTypeDescriptor();
        return result;
    }

    @Override
    public String toStringAST() {
        return this.getChild(0).toStringAST() + " ? " + this.getChild(1).toStringAST() + " : " + this.getChild(2).toStringAST();
    }

    private void computeExitTypeDescriptor() {
        if (this.exitTypeDescriptor == null && this.children[1].exitTypeDescriptor != null && this.children[2].exitTypeDescriptor != null) {
            String leftDescriptor = this.children[1].exitTypeDescriptor;
            String rightDescriptor = this.children[2].exitTypeDescriptor;
            this.exitTypeDescriptor = leftDescriptor.equals(rightDescriptor) ? leftDescriptor : "Ljava/lang/Object";
        }
    }

    @Override
    public boolean isCompilable() {
        SpelNodeImpl condition = this.children[0];
        SpelNodeImpl left = this.children[1];
        SpelNodeImpl right = this.children[2];
        return condition.isCompilable() && left.isCompilable() && right.isCompilable() && CodeFlow.isBooleanCompatible(condition.exitTypeDescriptor) && left.exitTypeDescriptor != null && right.exitTypeDescriptor != null;
    }

    @Override
    public void generateCode(MethodVisitor mv, CodeFlow cf) {
        this.computeExitTypeDescriptor();
        cf.enterCompilationScope();
        this.children[0].generateCode(mv, cf);
        if (!CodeFlow.isPrimitive(cf.lastDescriptor())) {
            CodeFlow.insertUnboxInsns(mv, 'Z', cf.lastDescriptor());
        }
        cf.exitCompilationScope();
        Label elseTarget = new Label();
        Label endOfIf = new Label();
        mv.visitJumpInsn(153, elseTarget);
        cf.enterCompilationScope();
        this.children[1].generateCode(mv, cf);
        if (!CodeFlow.isPrimitive(this.exitTypeDescriptor)) {
            CodeFlow.insertBoxIfNecessary(mv, cf.lastDescriptor().charAt(0));
        }
        cf.exitCompilationScope();
        mv.visitJumpInsn(167, endOfIf);
        mv.visitLabel(elseTarget);
        cf.enterCompilationScope();
        this.children[2].generateCode(mv, cf);
        if (!CodeFlow.isPrimitive(this.exitTypeDescriptor)) {
            CodeFlow.insertBoxIfNecessary(mv, cf.lastDescriptor().charAt(0));
        }
        cf.exitCompilationScope();
        mv.visitLabel(endOfIf);
        cf.pushDescriptor(this.exitTypeDescriptor);
    }
}

