/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.format.number;

import java.util.Set;
import org.qubership.profiler.shaded.org.springframework.context.support.EmbeddedValueResolutionSupport;
import org.qubership.profiler.shaded.org.springframework.format.AnnotationFormatterFactory;
import org.qubership.profiler.shaded.org.springframework.format.Formatter;
import org.qubership.profiler.shaded.org.springframework.format.Parser;
import org.qubership.profiler.shaded.org.springframework.format.Printer;
import org.qubership.profiler.shaded.org.springframework.format.annotation.NumberFormat;
import org.qubership.profiler.shaded.org.springframework.format.number.CurrencyStyleFormatter;
import org.qubership.profiler.shaded.org.springframework.format.number.NumberStyleFormatter;
import org.qubership.profiler.shaded.org.springframework.format.number.PercentStyleFormatter;
import org.qubership.profiler.shaded.org.springframework.util.NumberUtils;
import org.qubership.profiler.shaded.org.springframework.util.StringUtils;

public class NumberFormatAnnotationFormatterFactory
extends EmbeddedValueResolutionSupport
implements AnnotationFormatterFactory<NumberFormat> {
    @Override
    public Set<Class<?>> getFieldTypes() {
        return NumberUtils.STANDARD_NUMBER_TYPES;
    }

    @Override
    public Printer<Number> getPrinter(NumberFormat annotation, Class<?> fieldType) {
        return this.configureFormatterFrom(annotation);
    }

    @Override
    public Parser<Number> getParser(NumberFormat annotation, Class<?> fieldType) {
        return this.configureFormatterFrom(annotation);
    }

    private Formatter<Number> configureFormatterFrom(NumberFormat annotation) {
        if (StringUtils.hasLength(annotation.pattern())) {
            return new NumberStyleFormatter(this.resolveEmbeddedValue(annotation.pattern()));
        }
        NumberFormat.Style style = annotation.style();
        if (style == NumberFormat.Style.CURRENCY) {
            return new CurrencyStyleFormatter();
        }
        if (style == NumberFormat.Style.PERCENT) {
            return new PercentStyleFormatter();
        }
        return new NumberStyleFormatter();
    }
}

