/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.scripting.jruby;

import java.io.IOException;
import java.lang.reflect.Method;
import org.jruby.RubyException;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.qubership.profiler.shaded.org.springframework.beans.factory.BeanClassLoaderAware;
import org.qubership.profiler.shaded.org.springframework.scripting.ScriptCompilationException;
import org.qubership.profiler.shaded.org.springframework.scripting.ScriptFactory;
import org.qubership.profiler.shaded.org.springframework.scripting.ScriptSource;
import org.qubership.profiler.shaded.org.springframework.scripting.jruby.JRubyScriptUtils;
import org.qubership.profiler.shaded.org.springframework.util.Assert;
import org.qubership.profiler.shaded.org.springframework.util.ClassUtils;
import org.qubership.profiler.shaded.org.springframework.util.ReflectionUtils;

@Deprecated
public class JRubyScriptFactory
implements ScriptFactory,
BeanClassLoaderAware {
    private static final Method getMessageMethod = ClassUtils.getMethodIfAvailable(RubyException.class, "getMessage", new Class[0]);
    private final String scriptSourceLocator;
    private final Class<?>[] scriptInterfaces;
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();

    public JRubyScriptFactory(String scriptSourceLocator, Class<?> ... scriptInterfaces) {
        Assert.hasText(scriptSourceLocator, "'scriptSourceLocator' must not be empty");
        Assert.notEmpty(scriptInterfaces, "'scriptInterfaces' must not be empty");
        this.scriptSourceLocator = scriptSourceLocator;
        this.scriptInterfaces = scriptInterfaces;
    }

    @Override
    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    @Override
    public String getScriptSourceLocator() {
        return this.scriptSourceLocator;
    }

    @Override
    public Class<?>[] getScriptInterfaces() {
        return this.scriptInterfaces;
    }

    @Override
    public boolean requiresConfigInterface() {
        return true;
    }

    @Override
    public Object getScriptedObject(ScriptSource scriptSource, Class<?> ... actualInterfaces) throws IOException, ScriptCompilationException {
        try {
            return JRubyScriptUtils.createJRubyObject(scriptSource.getScriptAsString(), actualInterfaces, this.beanClassLoader);
        }
        catch (RaiseException ex) {
            String msg = null;
            RubyException rubyEx = ex.getException();
            if (rubyEx != null) {
                if (getMessageMethod != null) {
                    msg = ReflectionUtils.invokeMethod(getMessageMethod, rubyEx).toString();
                } else if (rubyEx.message != null) {
                    msg = rubyEx.message.toString();
                }
            }
            throw new ScriptCompilationException(scriptSource, msg != null ? msg : "Unexpected JRuby error", ex);
        }
        catch (JumpException ex) {
            throw new ScriptCompilationException(scriptSource, (Throwable)ex);
        }
    }

    @Override
    public Class<?> getScriptedObjectType(ScriptSource scriptSource) throws IOException, ScriptCompilationException {
        return null;
    }

    @Override
    public boolean requiresScriptedObjectRefresh(ScriptSource scriptSource) {
        return scriptSource.isModified();
    }

    public String toString() {
        return "JRubyScriptFactory: script source locator [" + this.scriptSourceLocator + "]";
    }
}

