/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.validation.beanvalidation;

import java.lang.reflect.Method;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.hibernate.validator.method.MethodConstraintViolationException;
import org.hibernate.validator.method.MethodValidator;
import org.qubership.profiler.shaded.org.aopalliance.intercept.MethodInterceptor;
import org.qubership.profiler.shaded.org.aopalliance.intercept.MethodInvocation;
import org.qubership.profiler.shaded.org.springframework.beans.factory.FactoryBean;
import org.qubership.profiler.shaded.org.springframework.beans.factory.SmartFactoryBean;
import org.qubership.profiler.shaded.org.springframework.core.BridgeMethodResolver;
import org.qubership.profiler.shaded.org.springframework.core.annotation.AnnotationUtils;
import org.qubership.profiler.shaded.org.springframework.util.ClassUtils;
import org.qubership.profiler.shaded.org.springframework.util.ReflectionUtils;
import org.qubership.profiler.shaded.org.springframework.validation.annotation.Validated;

public class MethodValidationInterceptor
implements MethodInterceptor {
    private static Method forExecutablesMethod;
    private static Method validateParametersMethod;
    private static Method validateReturnValueMethod;
    private volatile Validator validator;

    public MethodValidationInterceptor() {
        this(forExecutablesMethod != null ? Validation.buildDefaultValidatorFactory() : HibernateValidatorDelegate.buildValidatorFactory());
    }

    public MethodValidationInterceptor(ValidatorFactory validatorFactory) {
        this(validatorFactory.getValidator());
    }

    public MethodValidationInterceptor(Validator validator) {
        this.validator = validator;
    }

    @Override
    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (this.isFactoryBeanMetadataMethod(invocation.getMethod())) {
            return invocation.proceed();
        }
        Class<?>[] groups = this.determineValidationGroups(invocation);
        if (forExecutablesMethod != null) {
            Set result;
            Object execVal;
            try {
                execVal = ReflectionUtils.invokeMethod(forExecutablesMethod, this.validator);
            }
            catch (AbstractMethodError err) {
                Validator nativeValidator = this.validator.unwrap(Validator.class);
                execVal = ReflectionUtils.invokeMethod(forExecutablesMethod, nativeValidator);
                this.validator = nativeValidator;
            }
            Method methodToValidate = invocation.getMethod();
            try {
                result = (Set)ReflectionUtils.invokeMethod(validateParametersMethod, execVal, invocation.getThis(), methodToValidate, invocation.getArguments(), groups);
            }
            catch (IllegalArgumentException ex) {
                methodToValidate = BridgeMethodResolver.findBridgedMethod(ClassUtils.getMostSpecificMethod(invocation.getMethod(), invocation.getThis().getClass()));
                result = (Set)ReflectionUtils.invokeMethod(validateParametersMethod, execVal, invocation.getThis(), methodToValidate, invocation.getArguments(), groups);
            }
            if (!result.isEmpty()) {
                throw new ConstraintViolationException(result);
            }
            Object returnValue = invocation.proceed();
            result = (Set)ReflectionUtils.invokeMethod(validateReturnValueMethod, execVal, invocation.getThis(), methodToValidate, returnValue, groups);
            if (!result.isEmpty()) {
                throw new ConstraintViolationException(result);
            }
            return returnValue;
        }
        return HibernateValidatorDelegate.invokeWithinValidation(invocation, this.validator, groups);
    }

    private boolean isFactoryBeanMetadataMethod(Method method) {
        Class<?> clazz = method.getDeclaringClass();
        if (clazz.isInterface()) {
            return (clazz == FactoryBean.class || clazz == SmartFactoryBean.class) && !method.getName().equals("getObject");
        }
        Class factoryBeanType = null;
        if (SmartFactoryBean.class.isAssignableFrom(clazz)) {
            factoryBeanType = SmartFactoryBean.class;
        } else if (FactoryBean.class.isAssignableFrom(clazz)) {
            factoryBeanType = FactoryBean.class;
        }
        return factoryBeanType != null && !method.getName().equals("getObject") && ClassUtils.hasMethod(factoryBeanType, method.getName(), method.getParameterTypes());
    }

    protected Class<?>[] determineValidationGroups(MethodInvocation invocation) {
        Validated validatedAnn = AnnotationUtils.findAnnotation(invocation.getMethod(), Validated.class);
        if (validatedAnn == null) {
            validatedAnn = AnnotationUtils.findAnnotation(invocation.getThis().getClass(), Validated.class);
        }
        return validatedAnn != null ? validatedAnn.value() : new Class[]{};
    }

    static {
        try {
            forExecutablesMethod = Validator.class.getMethod("forExecutables", new Class[0]);
            Class<?> executableValidatorClass = forExecutablesMethod.getReturnType();
            validateParametersMethod = executableValidatorClass.getMethod("validateParameters", Object.class, Method.class, Object[].class, Class[].class);
            validateReturnValueMethod = executableValidatorClass.getMethod("validateReturnValue", Object.class, Method.class, Object.class, Class[].class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class HibernateValidatorDelegate {
        private HibernateValidatorDelegate() {
        }

        public static ValidatorFactory buildValidatorFactory() {
            return ((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).buildValidatorFactory();
        }

        public static Object invokeWithinValidation(MethodInvocation invocation, Validator validator, Class<?>[] groups) throws Throwable {
            MethodValidator methodValidator = validator.unwrap(MethodValidator.class);
            Set result = methodValidator.validateAllParameters(invocation.getThis(), invocation.getMethod(), invocation.getArguments(), (Class[])groups);
            if (!result.isEmpty()) {
                throw new MethodConstraintViolationException(result);
            }
            Object returnValue = invocation.proceed();
            result = methodValidator.validateReturnValue(invocation.getThis(), invocation.getMethod(), returnValue, (Class[])groups);
            if (!result.isEmpty()) {
                throw new MethodConstraintViolationException(result);
            }
            return returnValue;
        }
    }
}

