/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.threaddump.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.qubership.profiler.shaded.org.slf4j.Logger;
import org.qubership.profiler.shaded.org.slf4j.LoggerFactory;
import org.qubership.profiler.threaddump.parser.MethodThreadLineInfo;
import org.qubership.profiler.threaddump.parser.ThreadFormatParser;
import org.qubership.profiler.threaddump.parser.ThreadInfo;
import org.qubership.profiler.threaddump.parser.ThreaddumpParser;

public class SunJMXThreadFormatParser
implements ThreadFormatParser {
    private static final Logger log = LoggerFactory.getLogger(SunJMXThreadFormatParser.class);
    private final Pattern threadPattern = Pattern.compile("\"(.*?)\" (waiting to lock|waiting on|locked|parking to wait for|eliminated)?");
    private final Pattern methodPattern = Pattern.compile("\t([\\p{Alnum}$_.<>/]+)\\(([^\\)]*)\\)");

    @Override
    public ThreadInfo parseThread(String s) {
        ThreadInfo threadinfo = new ThreadInfo();
        Matcher matcher = this.threadPattern.matcher(s);
        if (matcher.lookingAt()) {
            threadinfo.name = matcher.group(1);
            threadinfo.state = matcher.group(2).trim();
        } else {
            log.error("parseThread failed on: '" + s + "' using pattern '" + this.threadPattern + "'");
        }
        return threadinfo;
    }

    @Override
    public ThreaddumpParser.ThreadLineInfo parseThreadLine(String s) {
        MethodThreadLineInfo threadLineInfo;
        Matcher matcher = this.methodPattern.matcher(s);
        if (matcher.lookingAt()) {
            MethodThreadLineInfo method = new MethodThreadLineInfo();
            String s1 = matcher.group(1);
            int i = s1.lastIndexOf(46);
            method.setClassName(s1.substring(0, i));
            method.methodName = s1.substring(i + 1);
            String s2 = matcher.group(2);
            i = s2.indexOf(58);
            if (i == -1) {
                method.locationClass = s2.length() == 0 ? "Unknown" : s2;
            } else {
                method.locationClass = s2.substring(0, i);
                method.locationLineNo = s2.substring(i + 1);
            }
            threadLineInfo = method;
        } else {
            log.error("Unknown line: '" + s + "'");
            threadLineInfo = new MethodThreadLineInfo();
        }
        return threadLineInfo;
    }
}

