/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.servlet.layout;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.qubership.profiler.output.layout.Layout;

public class ServletLayout
extends Layout {
    protected HttpServletResponse resp;
    protected ServletOutputStream out;
    private final String encoding;
    private final String contentType;
    private boolean contentTypeSet;

    public ServletLayout(HttpServletResponse resp) {
        this(resp, "UTF-8", "text/html");
    }

    public ServletLayout(HttpServletResponse resp, String encoding, String contentType) {
        this.resp = resp;
        this.encoding = encoding;
        this.contentType = contentType;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public OutputStream getOutputStream() throws IOException {
        if (!this.contentTypeSet) {
            this.contentTypeSet = true;
            this.resp.setContentType(this.contentType + (this.encoding != null ? "; charset=" + this.encoding : ""));
        }
        this.out = this.resp.getOutputStream();
        return this.out;
    }

    public void putNextEntry(String id, String name, String type) {
    }

    public void close() throws IOException {
        if (this.out == null) {
            return;
        }
        this.out.close();
        this.out = null;
    }
}

