/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.security;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.qubership.profiler.security.AbstractSecurityFilter;
import org.qubership.profiler.security.DummySecurityService;
import org.qubership.profiler.security.User;
import org.qubership.profiler.security.WinstoneAuthException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DummyAuthenticationFilter
extends AbstractSecurityFilter {
    private static final Logger logger = LoggerFactory.getLogger(DummyAuthenticationFilter.class);

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    @Override
    protected void doFilter(HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpSession session = httpRequest.getSession();
        String userName = httpRequest.getParameter("username");
        String userPassword = httpRequest.getParameter("password");
        try {
            if (StringUtils.isNotEmpty((String)userName) && StringUtils.isNotEmpty((String)userPassword)) {
                User currentUser = DummySecurityService.getInstance().tryAuthenticate(userName, userPassword);
                session.setAttribute("AUTHENTICATED_USER", (Object)currentUser);
                String redirectTo = (String)session.getAttribute("LAST_USER_URI");
                session.removeAttribute(redirectTo);
                httpResponse.sendRedirect(redirectTo != null ? redirectTo : "/index.html");
                logger.debug("User {} successfully authenticated", (Object)userName);
            }
        }
        catch (WinstoneAuthException winstoneAuthException) {
            // empty catch block
        }
        filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
    }
}

