/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.servlet;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.qubership.profiler.config.AnalyzerWhiteList;
import org.qubership.profiler.dom.ProfiledTreeStreamVisitor;
import org.qubership.profiler.fetch.FetchDbmsHprof;
import org.qubership.profiler.fetch.FetchJFRAllocations;
import org.qubership.profiler.fetch.FetchJFRCpu;
import org.qubership.profiler.fetch.FetchStackcollapse;
import org.qubership.profiler.fetch.FetchThreadDump;
import org.qubership.profiler.io.CallRowid;
import org.qubership.profiler.io.FileNameUtils;
import org.qubership.profiler.io.ReactorChainsResolver;
import org.qubership.profiler.output.CallTreeMediator;
import org.qubership.profiler.output.CallTreeParams;
import org.qubership.profiler.output.layout.Layout;
import org.qubership.profiler.output.layout.SinglePageLayout;
import org.qubership.profiler.output.layout.ZipLayout;
import org.qubership.profiler.servlet.AnalyzeSourceFormat;
import org.qubership.profiler.servlet.HttpServletBase;
import org.qubership.profiler.servlet.ServletResourceAppender;
import org.qubership.profiler.servlet.SpringBootInitializer;
import org.qubership.profiler.servlet.layout.ServletLayout;
import org.qubership.profiler.timeout.ProfilerTimeoutException;

public class TreeFetcher
extends HttpServletBase<CallTreeMediator, RequestContext> {
    private static SinglePageLayout.Template template;
    private ReactorChainsResolver reactorChainsResolver;
    public static final String CHAIN_ID_KEY = "chain";

    @Override
    protected RequestContext createContext() {
        return new RequestContext();
    }

    public void init(ServletConfig config) throws ServletException {
        ServletContext context = config.getServletContext();
        ServletResourceAppender appender = new ServletResourceAppender(context);
        this.reactorChainsResolver = SpringBootInitializer.reactorChainsResolver();
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            appender.append("/single-page/tree.html", baos);
            Charset charset = StandardCharsets.UTF_8;
            template = SinglePageLayout.getTemplate((String)baos.toString(charset.name()), (Charset)charset);
        }
        catch (IOException e) {
            throw new ServletException("Unable to read /tree.html template", (Throwable)e);
        }
    }

    @Override
    protected Layout identifyLayout(RequestContext context, HttpServletRequest req, HttpServletResponse resp) {
        ServletLayout l;
        if (!req.getRequestURI().endsWith(".zip")) {
            l = new ServletLayout(resp, "UTF-8", "application/x-javascript");
        } else {
            context.isZip = true;
            l = new ServletLayout(resp, "UTF-8", "application/octet-stream");
            l = new ZipLayout((Layout)l);
            l = new SinglePageLayout((Layout)l, template);
        }
        int defaultTrimSize = context.isZip ? 200000000 : 15000;
        context.paramsTrimSize = Integer.getInteger("org.qubership.profiler.Profiler.PARAMS_TRIM_SIZE", defaultTrimSize);
        context.paramTrimSizeForUI = (int)this.parseLong(req, "params-trim-size", 15000L);
        return l;
    }

    @Override
    protected CallTreeMediator getMediator(RequestContext context, HttpServletRequest req, HttpServletResponse resp, Layout layout) {
        String id;
        String path = req.getRequestURI();
        int extPos = path.lastIndexOf(46);
        String format = extPos == -1 ? "html" : path.substring(extPos + 1);
        String callback = req.getParameter("callback");
        if (callback == null) {
            callback = "html".equals(format) ? "treedata" : "dataReceived";
        }
        int callbackId = (id = req.getParameter("id")) == null ? 0 : Integer.valueOf(id);
        CallTreeParams params = new CallTreeParams(req.getParameterMap());
        return new CallTreeMediator(layout, callback, callbackId, params, context.paramTrimSizeForUI, context.isZip, this.reactorChainsResolver.folderIDMapping(req));
    }

    @Override
    protected Runnable identifyAction(RequestContext context, HttpServletRequest req, HttpServletResponse resp, final CallTreeMediator mediator) {
        final Runnable action = this.identifyActionInner(context, req, resp, mediator);
        return new Runnable(){

            @Override
            public void run() {
                try {
                    action.run();
                }
                catch (ProfilerTimeoutException e) {
                    mediator.onError((Throwable)e);
                }
            }
        };
    }

    private Runnable identifyActionInner(RequestContext context, HttpServletRequest req, HttpServletResponse resp, CallTreeMediator mediator) {
        String dumpsFile = req.getParameter("file");
        String zipName = req.getPathInfo();
        zipName = zipName == null ? "tree" : zipName.substring(1, zipName.length() - 4);
        mediator.setMainFileName(zipName);
        if (dumpsFile == null) {
            String[] treeIds = req.getParameterValues("i");
            if (treeIds == null) {
                treeIds = req.getParameterValues("i[]");
            }
            if (treeIds == null) {
                throw new IllegalArgumentException("treeIds should not be null");
            }
            HashMap<Object, Object> args = new HashMap<Object, Object>();
            if (context.isZip) {
                args.put("ro", "1");
            }
            args.put("i", Arrays.asList(treeIds));
            Enumeration paramNames = req.getParameterNames();
            while (paramNames.hasMoreElements()) {
                String param = (String)paramNames.nextElement();
                if (!param.startsWith("f[")) continue;
                args.put(param, req.getParameter(param));
            }
            for (Object e : req.getParameterMap().entrySet()) {
                Map.Entry entry = (Map.Entry)e;
                String key = (String)entry.getKey();
                if (key.charAt(0) != 'z') continue;
                String[] value = (String[])entry.getValue();
                args.put(key, value[0]);
            }
            mediator.mergeArgs(args);
            List[] split = this.reactorChainsResolver.splitChainIDs(treeIds);
            int n = split[0].size();
            List reactorCallIDs = this.reactorChainsResolver.resolveReactorChains(req, split[1]);
            CallRowid[] callIds = new CallRowid[n + reactorCallIDs.size()];
            Map params = req.getParameterMap();
            for (int i = 0; i < n; ++i) {
                callIds[i] = new CallRowid((String)split[0].get(i), params);
            }
            for (int j = 0; j < reactorCallIDs.size(); ++j) {
                callIds[j + n] = (CallRowid)reactorCallIDs.get(j);
            }
            String[] beginParams = (String[])params.get("s");
            String[] endParams = (String[])params.get("e");
            long begin = beginParams != null && beginParams.length == 1 ? Long.parseLong(beginParams[0]) : Long.MIN_VALUE;
            long end = endParams != null && endParams.length == 1 ? Long.parseLong(endParams[0]) : Long.MAX_VALUE;
            return SpringBootInitializer.fetchCallTreeFactory().fetchCallTree(mediator, callIds, context.paramsTrimSize, begin, end);
        }
        if (!AnalyzerWhiteList.checkAccess((File)new File(dumpsFile = FileNameUtils.trimFileName((String)dumpsFile)))) {
            mediator.onError((Throwable)new AccessDeniedException(dumpsFile, null, "Access denied. Edit applications/execution-statistics-collector/config/analyzer_white_list.cfg to grant access."));
            return new Runnable(){

                @Override
                public void run() {
                }
            };
        }
        AnalyzeSourceFormat format = AnalyzeSourceFormat.AUTO;
        String formatStr = req.getParameter("format");
        if (formatStr != null) {
            format = AnalyzeSourceFormat.valueOf(formatStr.toUpperCase());
        }
        if (format == AnalyzeSourceFormat.AUTO) {
            format = dumpsFile.endsWith(".jfr") ? AnalyzeSourceFormat.JFR_ALLOCATION : (dumpsFile.endsWith(".trc") || dumpsFile.endsWith(".raw") ? AnalyzeSourceFormat.DBMS_HPROF : (dumpsFile.endsWith("collapsed.log") || dumpsFile.endsWith(".aprof.raw") ? AnalyzeSourceFormat.STACKCOLLAPSE : AnalyzeSourceFormat.THREAD_DUMP));
        }
        if (format == AnalyzeSourceFormat.JFR_ALLOCATION) {
            mediator.setDurationFormat(CallTreeMediator.DurationFormat.BYTES);
            return new FetchJFRAllocations((ProfiledTreeStreamVisitor)mediator, dumpsFile);
        }
        if (format == AnalyzeSourceFormat.JFR_CPU) {
            mediator.setDurationFormat(CallTreeMediator.DurationFormat.SAMPLES);
            return new FetchJFRCpu((ProfiledTreeStreamVisitor)mediator, dumpsFile);
        }
        if (format == AnalyzeSourceFormat.THREAD_DUMP) {
            mediator.setDurationFormat(CallTreeMediator.DurationFormat.SAMPLES);
            long firstByte = this.parseLong(req, "firstByte", 0L);
            long l = this.parseLong(req, "lastByte", Long.MAX_VALUE);
            return new FetchThreadDump((ProfiledTreeStreamVisitor)mediator, dumpsFile, firstByte, l);
        }
        if (format == AnalyzeSourceFormat.DBMS_HPROF) {
            return new FetchDbmsHprof((ProfiledTreeStreamVisitor)mediator, dumpsFile, SpringBootInitializer.getApplicationContext());
        }
        if (format == AnalyzeSourceFormat.STACKCOLLAPSE) {
            mediator.setDurationFormat(CallTreeMediator.DurationFormat.SAMPLES);
            long firstByte = this.parseLong(req, "firstByte", 0L);
            long l = this.parseLong(req, "lastByte", Long.MAX_VALUE);
            return new FetchStackcollapse(mediator, dumpsFile, firstByte, l);
        }
        throw new IllegalArgumentException("Unexpected output format: " + (Object)((Object)format));
    }

    static class RequestContext {
        private boolean isZip;
        private int paramsTrimSize;
        private int paramTrimSizeForUI;

        RequestContext() {
        }
    }
}

