/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.security;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang.StringUtils;
import org.qubership.profiler.security.User;
import org.qubership.profiler.security.WinstoneAuthException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DummySecurityService {
    private boolean securityEnabled = false;
    private User defaultUser;
    private static volatile DummySecurityService instance;
    private static final Logger logger;

    public User tryAuthenticate(String userName, String password) throws WinstoneAuthException {
        if (!this.securityEnabled) {
            throw new IllegalStateException("Dummy security is disabled");
        }
        String encodedPassword = this.encryptPassword(password);
        if (this.defaultUser.getName().equals(userName) && this.defaultUser.getEncodedPassword().equals(encodedPassword)) {
            return this.defaultUser;
        }
        throw new WinstoneAuthException("There is no user with the given name and password");
    }

    private void initialize() {
        String defaultUserName = System.getenv("PROFILER_USERNAME");
        String defaultUserPassword = System.getenv("PROFILER_USER_PASSWORD");
        if (StringUtils.isNotBlank((String)defaultUserName) && StringUtils.isNotBlank((String)defaultUserPassword)) {
            logger.info("DummySecurity is enabled");
            this.defaultUser = new User();
            this.defaultUser.setName(defaultUserName);
            this.defaultUser.setEncodedPassword(this.encryptPassword(defaultUserPassword));
            this.securityEnabled = true;
        } else {
            logger.info("Dummy security is disabled");
        }
    }

    public boolean isSecurityEnabled() {
        return this.securityEnabled;
    }

    private String encryptPassword(String password) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(password.getBytes());
            byte[] digest = md5.digest();
            return DatatypeConverter.printHexBinary((byte[])digest);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Impossible to encrypt password", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DummySecurityService getInstance() {
        DummySecurityService localInstance = instance;
        if (localInstance != null) return localInstance;
        Class<DummySecurityService> clazz = DummySecurityService.class;
        synchronized (DummySecurityService.class) {
            localInstance = instance;
            if (localInstance != null) return localInstance;
            instance = localInstance = new DummySecurityService();
            localInstance.initialize();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return localInstance;
        }
    }

    static {
        logger = LoggerFactory.getLogger(DummySecurityService.class);
    }
}

