/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.audit;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class UsernameFilter
implements Filter {
    public static final String PROFILER_REMOTE_USERNAME = "remote.username";
    protected final Logger log = LoggerFactory.getLogger(UsernameFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        try {
            MDC.put((String)"req.remoteAddr", (String)servletRequest.getRemoteAddr());
            if (servletRequest instanceof HttpServletRequest) {
                HttpServletRequest req = (HttpServletRequest)servletRequest;
                HttpSession session = req.getSession();
                String remoteUser = req.getRemoteUser();
                if (remoteUser == null && session != null) {
                    remoteUser = (String)session.getAttribute(PROFILER_REMOTE_USERNAME);
                }
                MDC.put((String)"req.remoteUser", (String)remoteUser);
                if (session != null && remoteUser != null && session.getAttribute(PROFILER_REMOTE_USERNAME) == null) {
                    session.setAttribute(PROFILER_REMOTE_USERNAME, (Object)remoteUser);
                    this.log.info("login");
                }
                this.log.trace("page accessed {}?{}", (Object)req.getRequestURI(), (Object)req.getQueryString());
            }
            filterChain.doFilter(servletRequest, servletResponse);
        }
        finally {
            MDC.remove((String)"req.remoteUser");
            MDC.remove((String)"req.remoteAddr");
        }
    }

    public void destroy() {
    }
}

