/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.MDC;

public class Slf4jMDCFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        this.setMdc(servletRequest);
        try {
            filterChain.doFilter(servletRequest, servletResponse);
        }
        finally {
            this.clearMdc();
        }
    }

    void setMdc(ServletRequest request) {
        MDC.put((String)"req.remoteHost", (String)request.getRemoteHost());
        if (request instanceof HttpServletRequest) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            MDC.put((String)"req.requestURI", (String)httpServletRequest.getRequestURI());
            StringBuffer requestURL = httpServletRequest.getRequestURL();
            if (requestURL != null) {
                MDC.put((String)"req.requestURL", (String)requestURL.toString());
            }
            MDC.put((String)"req.method", (String)httpServletRequest.getMethod());
            MDC.put((String)"req.queryString", (String)httpServletRequest.getQueryString());
            MDC.put((String)"req.userAgent", (String)httpServletRequest.getHeader("User-Agent"));
            MDC.put((String)"req.xForwardedFor", (String)httpServletRequest.getHeader("X-Forwarded-For"));
        }
    }

    private void clearMdc() {
        MDC.remove((String)"req.remoteHost");
        MDC.remove((String)"req.requestURI");
        MDC.remove((String)"req.queryString");
        MDC.remove((String)"req.requestURL");
        MDC.remove((String)"req.method");
        MDC.remove((String)"req.userAgent");
        MDC.remove((String)"req.xForwardedFor");
    }

    public void destroy() {
    }
}

