/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.servlet;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.spi.FilterReply;
import com.netcracker.profiler.servlet.LogbackInitializer;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.springframework.boot.logging.AbstractLoggingSystem;
import org.springframework.boot.logging.LogFile;
import org.springframework.boot.logging.LogLevel;
import org.springframework.boot.logging.LoggerConfiguration;
import org.springframework.boot.logging.LoggingInitializationContext;
import org.springframework.boot.logging.LoggingSystem;
import org.springframework.boot.logging.LoggingSystemFactory;
import org.springframework.boot.logging.LoggingSystemProperties;
import org.springframework.boot.logging.Slf4JLoggingSystem;
import org.springframework.boot.logging.logback.LogbackLoggingSystemProperties;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class Logback2LoggingSystem
extends Slf4JLoggingSystem {
    private static final String CONFIGURATION_FILE_PROPERTY = "logback.configurationFile";
    private static final AbstractLoggingSystem.LogLevels<Level> LEVELS = new AbstractLoggingSystem.LogLevels();
    private static final TurboFilter FILTER;

    public Logback2LoggingSystem(ClassLoader classLoader) {
        super(classLoader);
    }

    public LoggingSystemProperties getSystemProperties(ConfigurableEnvironment environment) {
        return new LogbackLoggingSystemProperties((Environment)environment);
    }

    protected String[] getStandardConfigLocations() {
        return new String[]{"logback-test.groovy", "logback-test.xml", "logback.groovy", "logback.xml"};
    }

    public void beforeInitialize() {
        LoggerContext loggerContext = this.getLoggerContext();
        if (this.isAlreadyInitialized(loggerContext)) {
            return;
        }
        super.beforeInitialize();
        loggerContext.getTurboFilterList().add((Object)FILTER);
    }

    public void initialize(LoggingInitializationContext initializationContext, String configLocation, LogFile logFile) {
        LoggerContext loggerContext = this.getLoggerContext();
        if (this.isAlreadyInitialized(loggerContext)) {
            return;
        }
        super.initialize(initializationContext, configLocation, logFile);
        loggerContext.getTurboFilterList().remove((Object)FILTER);
        this.markAsInitialized(loggerContext);
        if (StringUtils.hasText((String)System.getProperty(CONFIGURATION_FILE_PROPERTY))) {
            this.getLogger(Logback2LoggingSystem.class.getName()).warn("Ignoring 'logback.configurationFile' system property. Please use 'logging.config' instead.");
        }
    }

    protected void loadDefaults(LoggingInitializationContext initializationContext, LogFile logFile) {
        LogbackInitializer.initLogback();
    }

    protected void loadConfiguration(LoggingInitializationContext initializationContext, String location, LogFile logFile) {
        LogbackInitializer.initLogback();
    }

    public void cleanUp() {
        LoggerContext context = this.getLoggerContext();
        this.markAsUninitialized(context);
        super.cleanUp();
        context.getStatusManager().clear();
        context.getTurboFilterList().remove((Object)FILTER);
    }

    protected void reinitialize(LoggingInitializationContext initializationContext) {
        this.getLoggerContext().reset();
        this.getLoggerContext().getStatusManager().clear();
        this.loadConfiguration(initializationContext, this.getSelfInitializationConfig(), null);
    }

    public List<LoggerConfiguration> getLoggerConfigurations() {
        ArrayList<LoggerConfiguration> result = new ArrayList<LoggerConfiguration>();
        for (Logger logger : this.getLoggerContext().getLoggerList()) {
            result.add(this.getLoggerConfiguration(logger));
        }
        result.sort(CONFIGURATION_COMPARATOR);
        return result;
    }

    public LoggerConfiguration getLoggerConfiguration(String loggerName) {
        String name = this.getLoggerName(loggerName);
        LoggerContext loggerContext = this.getLoggerContext();
        return this.getLoggerConfiguration(loggerContext.exists(name));
    }

    private String getLoggerName(String name) {
        if (!StringUtils.hasLength((String)name) || "ROOT".equals(name)) {
            return "ROOT";
        }
        return name;
    }

    private LoggerConfiguration getLoggerConfiguration(Logger logger) {
        if (logger == null) {
            return null;
        }
        LogLevel level = LEVELS.convertNativeToSystem((Object)logger.getLevel());
        LogLevel effectiveLevel = LEVELS.convertNativeToSystem((Object)logger.getEffectiveLevel());
        String name = this.getLoggerName(logger.getName());
        return new LoggerConfiguration(name, level, effectiveLevel);
    }

    public Set<LogLevel> getSupportedLogLevels() {
        return LEVELS.getSupported();
    }

    public void setLogLevel(String loggerName, LogLevel level) {
        Logger logger = this.getLogger(loggerName);
        if (logger != null) {
            logger.setLevel((Level)LEVELS.convertSystemToNative(level));
        }
    }

    public Runnable getShutdownHandler() {
        return () -> this.getLoggerContext().stop();
    }

    private Logger getLogger(String name) {
        LoggerContext factory = this.getLoggerContext();
        return factory.getLogger(this.getLoggerName(name));
    }

    private LoggerContext getLoggerContext() {
        ILoggerFactory factory = LoggerFactory.getILoggerFactory();
        Assert.isInstanceOf(LoggerContext.class, (Object)factory, () -> String.format("LoggerFactory is not a Logback LoggerContext but Logback is on the classpath. Either remove Logback or the competing implementation (%s loaded from %s). If you are using WebLogic you will need to add 'org.slf4j' to prefer-application-packages in WEB-INF/weblogic.xml", factory.getClass(), this.getLocation(factory)));
        return (LoggerContext)factory;
    }

    private Object getLocation(ILoggerFactory factory) {
        try {
            ProtectionDomain protectionDomain = factory.getClass().getProtectionDomain();
            CodeSource codeSource = protectionDomain.getCodeSource();
            if (codeSource != null) {
                return codeSource.getLocation();
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return "unknown location";
    }

    private boolean isAlreadyInitialized(LoggerContext loggerContext) {
        return loggerContext.getObject(LoggingSystem.class.getName()) != null;
    }

    private void markAsInitialized(LoggerContext loggerContext) {
        loggerContext.putObject(LoggingSystem.class.getName(), new Object());
    }

    private void markAsUninitialized(LoggerContext loggerContext) {
        loggerContext.removeObject(LoggingSystem.class.getName());
    }

    static {
        LEVELS.map(LogLevel.TRACE, (Object)Level.TRACE);
        Level all = Level.ALL;
        LEVELS.map(LogLevel.TRACE, (Object)all);
        LEVELS.map(LogLevel.DEBUG, (Object)Level.DEBUG);
        LEVELS.map(LogLevel.INFO, (Object)Level.INFO);
        LEVELS.map(LogLevel.WARN, (Object)Level.WARN);
        LEVELS.map(LogLevel.ERROR, (Object)Level.ERROR);
        LEVELS.map(LogLevel.FATAL, (Object)Level.ERROR);
        LEVELS.map(LogLevel.OFF, (Object)Level.OFF);
        FILTER = new TurboFilter(){

            public FilterReply decide(Marker marker, Logger logger, Level level, String format, Object[] params, Throwable t) {
                return FilterReply.DENY;
            }
        };
    }

    @Order(value=-2147483648)
    public static class Factory
    implements LoggingSystemFactory {
        private static final boolean PRESENT = ClassUtils.isPresent((String)"ch.qos.logback.classic.LoggerContext", (ClassLoader)Factory.class.getClassLoader());

        public LoggingSystem getLoggingSystem(ClassLoader classLoader) {
            if (PRESENT) {
                return new Logback2LoggingSystem(classLoader);
            }
            return null;
        }
    }
}

