/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.filter;

import com.netcracker.profiler.timeout.ProfilerTimeoutException;
import com.netcracker.profiler.timeout.ProfilerTimeoutHandler;
import jakarta.inject.Singleton;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

@Singleton
public class ProfilerTimeoutFilter
implements Filter {
    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws ServletException, IOException {
        ProfilerTimeoutHandler.scheduleTimeout();
        try {
            chain.doFilter(req, resp);
        }
        catch (ProfilerTimeoutException e) {
            HttpServletResponse res;
            if (resp instanceof HttpServletResponse && !(res = (HttpServletResponse)resp).isCommitted()) {
                res.sendError(408);
            }
        }
        finally {
            ProfilerTimeoutHandler.cancelTimeout();
        }
    }

    public void init(FilterConfig config) throws ServletException {
    }
}

