/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.guice;

import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.servlet.ServletModule;
import com.netcracker.profiler.audit.UsernameFilter;
import com.netcracker.profiler.filter.AddContentTypeForHtmlFilesFilter;
import com.netcracker.profiler.filter.AddDefaultHeadersFilter;
import com.netcracker.profiler.filter.CachingFilter;
import com.netcracker.profiler.filter.GzipResponseFilter;
import com.netcracker.profiler.filter.ProfilerTimeoutFilter;
import com.netcracker.profiler.filter.Slf4jMDCFilter;
import com.netcracker.profiler.guice.IsReadFromDump;
import com.netcracker.profiler.guice.ParsersModule;
import com.netcracker.profiler.security.DummyAuthenticationFilter;
import com.netcracker.profiler.security.DummySecurityFilter;
import com.netcracker.profiler.security.DummySecurityService;
import com.netcracker.profiler.security.csrf.CSRFGuardFilter;
import com.netcracker.profiler.security.csrf.CsrfTokenServlet;
import com.netcracker.profiler.servlet.ActivePODsFetcher;
import com.netcracker.profiler.servlet.CallFetcher;
import com.netcracker.profiler.servlet.Config;
import com.netcracker.profiler.servlet.DumpExporterServlet;
import com.netcracker.profiler.servlet.ExcelExporterServlet;
import com.netcracker.profiler.servlet.Metrics;
import com.netcracker.profiler.servlet.RawData;
import com.netcracker.profiler.servlet.StreamsDownloaderServlet;
import com.netcracker.profiler.servlet.ThreadDump;
import com.netcracker.profiler.servlet.TreeFetcher;
import java.io.File;

public class WebModule
extends ServletModule {
    private final File serverDumpLocation;

    public WebModule(File serverDumpLocation) {
        this.serverDumpLocation = serverDumpLocation;
    }

    protected void configureServlets() {
        this.install((Module)new ParsersModule(this.serverDumpLocation));
        this.bind(Key.get(String.class, IsReadFromDump.class)).toInstance((Object)"true");
        this.bind(DummySecurityService.class);
        this.filter("/*", new String[0]).through(Slf4jMDCFilter.class);
        this.filter("/*", new String[0]).through(DummyAuthenticationFilter.class);
        this.filter("/*", new String[0]).through(DummySecurityFilter.class);
        this.filter("/*", new String[0]).through(UsernameFilter.class);
        this.filter("/*", new String[0]).through(CachingFilter.class);
        this.filter("/*", new String[0]).through(AddDefaultHeadersFilter.class);
        this.filter("/", new String[0]).through(AddContentTypeForHtmlFilesFilter.class);
        this.filter("*.html", new String[0]).through(AddContentTypeForHtmlFilesFilter.class);
        this.filter("*.html", new String[0]).through(GzipResponseFilter.class);
        this.filter("/tree", new String[0]).through(GzipResponseFilter.class);
        this.filter("*.js", new String[0]).through(GzipResponseFilter.class);
        this.filter("*.css", new String[0]).through(GzipResponseFilter.class);
        this.filter("/js/calls.js", new String[0]).through(ProfilerTimeoutFilter.class);
        this.filter("/tree/*", new String[0]).through(ProfilerTimeoutFilter.class);
        this.filter("/js/tree.js", new String[0]).through(ProfilerTimeoutFilter.class);
        this.filter("/*", new String[0]).through(CSRFGuardFilter.class);
        this.filter("/exportExcel", new String[0]).through(ProfilerTimeoutFilter.class);
        this.serve("/config/*", new String[0]).with(Config.class);
        this.serve("/js/calls.js", new String[0]).with(CallFetcher.class);
        this.serve("/get_clob/*", new String[0]).with(RawData.class);
        this.serve("/tree/*", new String[0]).with(TreeFetcher.class);
        this.serve("/js/tree.js", new String[0]).with(TreeFetcher.class);
        this.serve("/metrics/*", new String[0]).with(Metrics.class);
        this.serve("/threaddump/*", new String[0]).with(ThreadDump.class);
        this.serve("/fetchActivePods", new String[0]).with(ActivePODsFetcher.class);
        this.serve("/exportDump", new String[0]).with(DumpExporterServlet.class);
        this.serve("/downloadStream", new String[0]).with(StreamsDownloaderServlet.class);
        this.serve("/exportExcel", new String[0]).with(ExcelExporterServlet.class);
        this.serve("/api/csrf-token", new String[0]).with(CsrfTokenServlet.class);
    }
}

