/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.io;

import com.netcracker.profiler.io.ResettableBuffer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ResettableBufferedOutputStream
extends OutputStream
implements ResettableBuffer {
    private static final String ERROR_CLOSED = "Stream is already closed.";
    private OutputStream output;
    private ByteArrayOutputStream buffer;
    private final int thresholdBufferSize;
    private int writtenBytes;
    private boolean closed;

    public ResettableBufferedOutputStream(int thresholdBufferSize) {
        this(null, thresholdBufferSize);
    }

    public ResettableBufferedOutputStream(OutputStream output, int thresholdBufferSize) {
        this.output = output;
        this.thresholdBufferSize = thresholdBufferSize;
        this.buffer = new ByteArrayOutputStream(thresholdBufferSize);
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public void write(byte[] bytes, int offset, int length) throws IOException {
        this.checkClosed();
        if (this.isResettable()) {
            this.writtenBytes += length - offset;
            if (this.writtenBytes > this.thresholdBufferSize) {
                this.flushBuffer(true);
                this.output.write(bytes, offset, length);
            } else {
                this.buffer.write(bytes, offset, length);
            }
        } else {
            this.output.write(bytes, offset, length);
        }
    }

    private void flushBuffer(boolean thresholdBufferSizeExceeded) throws IOException {
        if (this.output == null) {
            if (thresholdBufferSizeExceeded) {
                this.writtenBytes = -1;
            }
            this.output = this.createOutputStream(thresholdBufferSizeExceeded);
        }
        this.buffer.writeTo(this.output);
        this.buffer = null;
    }

    protected OutputStream createOutputStream(boolean thresholdBufferSizeExceeded) throws IOException {
        throw new UnsupportedOperationException("You need to either override this method, or use the 2-arg constructor taking OutputStream instead.");
    }

    protected int getWrittenBytes() {
        return this.writtenBytes;
    }

    @Override
    public void reset() {
        if (this.isResettable()) {
            this.buffer = new ByteArrayOutputStream(this.thresholdBufferSize);
            this.writtenBytes = 0;
        }
    }

    @Override
    public void flush() throws IOException {
        this.checkClosed();
        if (!this.isResettable()) {
            this.output.flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.isResettable()) {
            this.flushBuffer(false);
        }
        this.output.close();
    }

    @Override
    public boolean isResettable() {
        return this.buffer != null;
    }

    private void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException(ERROR_CLOSED);
        }
    }
}

