/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.io;

import com.netcracker.profiler.io.ResettableBuffer;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;

public class ResettableBufferedWriter
extends Writer
implements ResettableBuffer {
    private Writer writer;
    private Charset charset;
    private CharArrayWriter buffer;
    private int bufferSize;
    private int writtenBytes;

    public ResettableBufferedWriter(Writer writer, int bufferSize, String characterEncoding) {
        this.writer = writer;
        this.bufferSize = bufferSize;
        this.charset = Charset.forName(characterEncoding);
        this.buffer = new CharArrayWriter(bufferSize);
    }

    @Override
    public void write(char[] chars, int offset, int length) throws IOException {
        if (this.buffer != null) {
            this.writtenBytes += this.charset.encode(CharBuffer.wrap(chars, offset, length)).limit();
            if (this.writtenBytes > this.bufferSize) {
                this.buffer.writeTo(this.writer);
                this.writer.write(chars, offset, length);
                this.buffer = null;
            } else {
                this.buffer.write(chars, offset, length);
            }
        } else {
            this.writer.write(chars, offset, length);
        }
    }

    @Override
    public void reset() {
        this.buffer = new CharArrayWriter(this.bufferSize);
        this.writtenBytes = 0;
    }

    @Override
    public void flush() throws IOException {
        if (this.buffer == null) {
            this.writer.flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.buffer != null) {
            this.buffer.writeTo(this.writer);
            this.buffer = null;
        }
        this.writer.close();
    }

    @Override
    public boolean isResettable() {
        return this.buffer != null;
    }
}

