/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.security;

import com.netcracker.profiler.security.AbstractSecurityFilter;
import com.netcracker.profiler.security.DummySecurityService;
import com.netcracker.profiler.security.User;
import com.netcracker.profiler.security.WinstoneAuthException;
import com.netcracker.profiler.util.StringUtils;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DummyAuthenticationFilter
extends AbstractSecurityFilter {
    private static final Logger logger = LoggerFactory.getLogger(DummyAuthenticationFilter.class);

    @Inject
    public DummyAuthenticationFilter(DummySecurityService securityService) {
        super(securityService);
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    @Override
    protected void doFilter(HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpSession session = httpRequest.getSession();
        String userName = httpRequest.getParameter("username");
        String userPassword = httpRequest.getParameter("password");
        try {
            if (StringUtils.isNotEmpty((CharSequence)userName) && StringUtils.isNotEmpty((CharSequence)userPassword)) {
                User currentUser = this.securityService.tryAuthenticate(userName, userPassword);
                session.setAttribute("AUTHENTICATED_USER", (Object)currentUser);
                String redirectTo = (String)session.getAttribute("LAST_USER_URI");
                session.removeAttribute(redirectTo);
                httpResponse.sendRedirect(redirectTo != null ? redirectTo : "/index.html");
                logger.debug("User {} successfully authenticated", (Object)userName);
            }
        }
        catch (WinstoneAuthException winstoneAuthException) {
            // empty catch block
        }
        filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
    }
}

