/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.security;

import com.netcracker.profiler.security.AbstractSecurityFilter;
import com.netcracker.profiler.security.DummySecurityService;
import com.netcracker.profiler.security.User;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;

@Singleton
public class DummySecurityFilter
extends AbstractSecurityFilter {
    @Inject
    public DummySecurityFilter(DummySecurityService securityService) {
        super(securityService);
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    @Override
    protected void doFilter(HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpSession session = httpRequest.getSession();
        User user = (User)session.getAttribute("AUTHENTICATED_USER");
        String path = httpRequest.getRequestURI();
        if (user == null && !path.startsWith("/login.html")) {
            if (path.startsWith("/index.html") || path.startsWith("/tree.html")) {
                session.setAttribute("LAST_USER_URI", (Object)(path + "?" + httpRequest.getQueryString()));
            }
            httpResponse.sendRedirect("/login.html");
        } else {
            filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
        }
    }

    @Override
    public void destroy() {
    }
}

