/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.security;

import com.netcracker.profiler.security.User;
import com.netcracker.profiler.security.WinstoneAuthException;
import com.netcracker.profiler.util.StringUtils;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DummySecurityService {
    private static final Logger logger = LoggerFactory.getLogger(DummySecurityService.class);
    private boolean securityEnabled = false;
    private User defaultUser;

    @Inject
    public DummySecurityService() {
        this.initialize();
    }

    public User tryAuthenticate(String userName, String password) throws WinstoneAuthException {
        if (!this.securityEnabled) {
            throw new IllegalStateException("Dummy security is disabled");
        }
        String encodedPassword = this.encryptPassword(password);
        if (this.defaultUser.getName().equals(userName) && this.defaultUser.getEncodedPassword().equals(encodedPassword)) {
            return this.defaultUser;
        }
        throw new WinstoneAuthException("There is no user with the given name and password");
    }

    private void initialize() {
        String defaultUserName = System.getenv("PROFILER_USERNAME");
        String defaultUserPassword = System.getenv("PROFILER_USER_PASSWORD");
        if (StringUtils.isNotBlank((CharSequence)defaultUserName) && StringUtils.isNotBlank((CharSequence)defaultUserPassword)) {
            logger.info("DummySecurity is enabled");
            this.defaultUser = new User();
            this.defaultUser.setName(defaultUserName);
            this.defaultUser.setEncodedPassword(this.encryptPassword(defaultUserPassword));
            this.securityEnabled = true;
        } else {
            logger.info("Dummy security is disabled");
        }
    }

    public boolean isSecurityEnabled() {
        return this.securityEnabled;
    }

    private String encryptPassword(String password) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(password.getBytes());
            return new BigInteger(1, md5.digest()).toString(16).toUpperCase();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Impossible to encrypt password", e);
        }
    }
}

