/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.security.csrf;

import com.netcracker.profiler.util.StringUtils;
import jakarta.inject.Singleton;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CSRFGuardFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(CSRFGuardFilter.class);

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpSession session;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String uri = request.getRequestURI();
        boolean redirected = this.checkCSRF(uri, request, response, session = request.getSession());
        if (!redirected) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    private boolean checkCSRF(String uri, HttpServletRequest request, HttpServletResponse response, HttpSession session) throws IOException {
        if (request.getMethod().equalsIgnoreCase("GET")) {
            return false;
        }
        String tokenFromRequest = request.getParameter("CSRF_TOKEN");
        if (tokenFromRequest == null) {
            tokenFromRequest = request.getHeader("CSRF_TOKEN");
        }
        if (StringUtils.isEmpty((CharSequence)tokenFromRequest)) {
            log.error("CSRF token is empty for {} at {}", (Object)request.getMethod(), (Object)uri);
            this.redirect((ServletResponse)response);
            return true;
        }
        Object csrfTokenObj = session.getAttribute("CSRF_TOKEN");
        if (csrfTokenObj == null) {
            log.error("The session does not contain CSRF token while client sent some for {} at {}", (Object)request.getMethod(), (Object)uri);
            this.redirect((ServletResponse)response);
            return true;
        }
        String tokenValue_p = csrfTokenObj.toString();
        if (!tokenFromRequest.equals(tokenValue_p)) {
            log.error("CSRF token in request does not match the token stored in session, {} at {}", (Object)request.getMethod(), (Object)uri);
            this.redirect((ServletResponse)response);
            return true;
        }
        return false;
    }

    private void redirect(ServletResponse response) throws IOException {
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        httpResponse.sendError(403);
    }

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }
}

