/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.servlet;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netcracker.profiler.io.IActivePODReporter;
import com.netcracker.profiler.io.TemporalRequestParams;
import com.netcracker.profiler.io.TemporalUtils;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ActivePODsFetcher
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(ActivePODsFetcher.class);
    private final IActivePODReporter reporter;

    @Inject
    public ActivePODsFetcher(IActivePODReporter reporter) {
        this.reporter = reporter;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        TemporalRequestParams temporal = TemporalUtils.parseTemporal((HttpServletRequest)req);
        String searchConditions = req.getParameter("searchConditions");
        List report = this.reporter.reportActivePODs(searchConditions, temporal);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.writeValue((OutputStream)resp.getOutputStream(), (Object)report);
    }
}

