/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.servlet;

import com.netcracker.profiler.guice.IsReadFromDump;
import com.netcracker.profiler.io.CallFilterer;
import com.netcracker.profiler.io.CallListener;
import com.netcracker.profiler.io.CallReaderFactory;
import com.netcracker.profiler.io.CallToJS;
import com.netcracker.profiler.io.CallToJSFactory;
import com.netcracker.profiler.io.DurationFiltererImpl;
import com.netcracker.profiler.io.ICallReader;
import com.netcracker.profiler.io.JSHelper;
import com.netcracker.profiler.io.LoggedContainersInfo;
import com.netcracker.profiler.io.TemporalRequestParams;
import com.netcracker.profiler.io.TemporalUtils;
import com.netcracker.profiler.servlet.Installer;
import com.netcracker.profiler.servlet.util.DumperStatusProvider;
import com.netcracker.profiler.util.TimeHelper;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CallFetcher
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(CallFetcher.class);
    private static final int RESPONSE_BUFFER_SIZE = Integer.getInteger(CallFetcher.class.getName() + ".RESPONSE_BUFFER_SIZE", 256);
    private final CallReaderFactory callReaderFactory;
    private final CallToJSFactory callToJSFactory;
    private final Provider<LoggedContainersInfo> loggedContainersInfoProvider;
    private final String isReadFromDump;

    @Inject
    public CallFetcher(CallReaderFactory callReaderFactory, CallToJSFactory callToJSFactory, Provider<LoggedContainersInfo> loggedContainersInfoProvider, @IsReadFromDump String isReadFromDump) {
        this.callReaderFactory = callReaderFactory;
        this.callToJSFactory = callToJSFactory;
        this.loggedContainersInfoProvider = loggedContainersInfoProvider;
        this.isReadFromDump = isReadFromDump;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean isExternalScript = request.getServletPath().endsWith(".js");
        if (isExternalScript) {
            response.setBufferSize(RESPONSE_BUFFER_SIZE);
            response.setContentType("application/x-javascript; charset=utf-8");
        }
        PrintWriter out = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)response.getOutputStream(), "utf-8"), 10240), false);
        TemporalRequestParams temporal = TemporalUtils.parseTemporal((HttpServletRequest)request);
        String callback = request.getParameter("callback");
        if (callback == null) {
            callback = isExternalScript ? "dataReceived" : "callsdata";
        }
        callback = URLEncoder.encode(callback, "UTF-8");
        out.print(callback);
        out.print('(');
        String requestId = URLEncoder.encode(request.getParameter("id"), "UTF-8");
        out.print(requestId);
        out.print(", function(){");
        this.printStartupInfo(requestId, out, temporal);
        LinkedList<Exception> exceptions = new LinkedList<Exception>();
        try {
            List<ICallReader> readers = this.collectCallReaders(request, out, temporal);
            out.print("var er=isDump.addProperty(\"");
            out.print(this.isReadFromDump);
            out.print("\"");
            out.println(");");
            for (ICallReader iCallReader : readers) {
                iCallReader.find();
                exceptions.addAll(iCallReader.getExceptions());
            }
        }
        catch (Exception e) {
            exceptions.add(e);
            log.error("Failed to read profiler calls: ", (Throwable)e);
        }
        StringBuilder sb = new StringBuilder();
        for (Throwable throwable : exceptions) {
            log.error("Reporting the following exception: ", throwable);
            sb.append(throwable.getMessage());
            sb.append("\n");
        }
        if (sb.length() > 0) {
            out.print("app.notify.notify('create', 'jqn-error', {title:'Errors occurred',text:\"");
            JSHelper.escapeJS((Writer)out, (String)sb.toString());
            out.print("\"}, {expires:false, custom: true});\n");
        }
        out.print("},{timerange:{");
        out.print("min:");
        out.print(temporal.timerangeFrom);
        out.print(",max:");
        out.print(temporal.timerangeTo);
        out.print(",autoUpdate:");
        out.print(temporal.autoUpdate);
        out.print("}, duration:{");
        out.print("min:");
        out.print(temporal.durationFrom);
        if (temporal.durationTo != Long.MAX_VALUE) {
            out.print(",max:");
            out.print(temporal.durationTo);
        }
        out.print("},availableServices:");
        this.printAvailableServices(out);
        out.print("});");
        out.flush();
    }

    protected void printStartupInfo(String requestId, PrintWriter out, TemporalRequestParams temporal) throws IOException {
        if ("0".equals(requestId)) {
            String nonLoaded = Installer.getNonActiveProfilerWarning();
            if (nonLoaded != null) {
                out.print("app.notify.notify('create', 'jqn-error', {title:'Profiler is not active',text:\"Profiler gathering agent is not runnig.<br>");
                JSHelper.escapeJS((Writer)out, (String)nonLoaded);
                out.print("\"}, {expires:false, custom: true});\n");
            }
            this.printServerClockWarning(temporal.serverUTC, temporal.clientUTC, out);
            this.printStartupRequirements(out);
        }
    }

    protected CallReaderFactory callReaderFactory() {
        return this.callReaderFactory;
    }

    protected CallToJS callToJs(PrintWriter out, CallFilterer cf) {
        return this.callToJSFactory.create(out, cf);
    }

    private List<ICallReader> collectCallReaders(HttpServletRequest request, PrintWriter out, TemporalRequestParams temporal) throws IOException {
        DurationFiltererImpl cf = new DurationFiltererImpl(temporal.durationFrom, temporal.durationTo);
        return this.callReaderFactory().collectCallReaders(request.getParameterMap(), temporal, (CallListener)this.callToJs(out, (CallFilterer)cf), (CallFilterer)cf);
    }

    private void printStartupRequirements(PrintWriter out) throws IOException {
        DumperStatusProvider dumper = DumperStatusProvider.INSTANCE;
        dumper.update();
        if (!dumper.isStarted) {
            return;
        }
        List<String> recommendations = Installer.getStartupArgumentRecommendations();
        for (String recommendation : recommendations) {
            out.print("app.notify.notify('create', 'jqn-error', {title:'Startup arguments misconfiguration',text:\"");
            JSHelper.escapeJS((Writer)out, (String)recommendation);
            out.print("\"}, {expires: 10000, custom: true});\n");
        }
    }

    protected List<String[]> getAvailableServices() {
        return ((LoggedContainersInfo)this.loggedContainersInfoProvider.get()).listPodDetails();
    }

    private void printAvailableServices(PrintWriter out) {
        List<String[]> podDetails = this.getAvailableServices();
        if (podDetails == null) {
            out.write("null");
            return;
        }
        out.write("{");
        this.printList(out, "podNames", podDetails, 0);
        out.write(",");
        this.printList(out, "serviceNames", podDetails, 1);
        out.write(",");
        this.printList(out, "namespaces", podDetails, 2);
        out.write("}");
    }

    private void printList(PrintWriter out, String listName, List<String[]> list, int index) {
        TreeSet<String> distinctList = new TreeSet<String>();
        for (String[] src : list) {
            distinctList.add(src[index]);
        }
        out.write(listName);
        out.write(":[");
        Iterator it = distinctList.iterator();
        while (it.hasNext()) {
            out.write("\"");
            out.write((String)it.next());
            out.write("\"");
            if (!it.hasNext()) continue;
            out.write(",");
        }
        out.write("]");
    }

    private void printServerClockWarning(long serverUTC, long clientUTC, PrintWriter out) {
        long diffInSeconds = Math.abs(serverUTC - clientUTC) / 1000L;
        if (diffInSeconds <= 10L) {
            return;
        }
        out.print("app.notify.notify('create', 'jqn-error', {title:'Server clock might be wrong',text:\"Looks like server clock is ");
        out.print(TimeHelper.humanizeDifference(null, (long)(serverUTC - clientUTC)));
        out.print("<br>Take this difference into consideration when applying timerange filters.<br>Ask IT to enable NTP time synchronization on both client and server\"}, {expires:false, custom: true});\n");
    }
}

