/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.servlet;

import com.netcracker.profiler.io.ExcelExporter;
import com.netcracker.profiler.io.TemporalRequestParams;
import com.netcracker.profiler.io.TemporalUtils;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ExcelExporterServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(ExcelExporterServlet.class);
    private final ExcelExporter excelExporter;

    @Inject
    public ExcelExporterServlet(ExcelExporter excelExporter) {
        this.excelExporter = excelExporter;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        TemporalRequestParams temporal = TemporalUtils.parseTemporal((HttpServletRequest)req);
        String serverAddress = req.getScheme() + "://" + req.getServerName() + ":" + req.getServerPort() + req.getContextPath();
        resp.setContentType("application/x-msdownload");
        resp.setHeader("Content-disposition", "attachment; filename=calls.xlsx");
        HashMap<String, String[]> params = new HashMap<String, String[]>(req.getParameterMap());
        this.splitParams(params, "nodes", "urlReplacePatterns");
        this.excelExporter.export(temporal, params, (OutputStream)resp.getOutputStream(), serverAddress);
    }

    private void splitParams(Map<String, String[]> params, String ... keys) {
        for (String key : keys) {
            String[] vals = params.get(key);
            if (vals == null || vals.length < 1) continue;
            String[] splitted = vals[0].trim().split(" ");
            if (splitted.length == 1 && splitted[0].isEmpty()) {
                splitted = new String[]{};
            }
            params.put(key, splitted);
        }
    }
}

